/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.mtx;

import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.ODataEdmProvider;
import com.sap.cds.adapter.odata.v4.metadata.mtx.AbstractEdmxProviderAccessor;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.mt.ExtensibilityService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.mtx.MtxUtils;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static Logger log = LoggerFactory.getLogger(MtxEdmxProviderAccessor.class);
    private final MetaDataAccessor<MetadataInfo> accessor;
    private final CdsRuntime runtime;

    public MtxEdmxProviderAccessor(CdsRuntime runtime) {
        this.runtime = runtime;
        SidecarAccess access = MtxUtils.getSidecarAccess();
        CacheParams cacheParams = MtxUtils.getCacheParams();
        this.accessor = new MetaDataAccessorImpl(access, cacheParams, (edmx, service) -> {
            ODataEdmProvider edmProvider;
            byte[] edmxBytes = edmx.getBytes(StandardCharsets.UTF_8);
            try {
                edmProvider = this.loadMetadataFiles(service, edmxBytes);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA_MTX, new Object[]{service, e});
            }
            String etag = this.calculateMetadataEtag(edmxBytes);
            return new MetadataInfo(edmProvider, etag);
        }, null);
        ExtensibilityService extService = (ExtensibilityService)runtime.getServiceCatalog().getService(ExtensibilityService.class, "ExtensibilityService$Default");
        extService.on("MODEL_CHANGED", null, context -> this.accessor.refresh(context.getUserInfo().getTenant()));
    }

    @Override
    protected MetadataInfo getMetadataInfo(String serviceName) {
        Locale locale = RequestContext.getCurrent((CdsRuntime)this.runtime).getParameterInfo().getLocale();
        String localeString = locale != null ? locale.getLanguage() : Locale.ENGLISH.getLanguage();
        log.debug("Retrieving model for service name '{}' and locale '{}'", (Object)serviceName, (Object)localeString);
        try {
            return (MetadataInfo)this.accessor.getEdmx(RequestContext.getCurrent((CdsRuntime)this.runtime).getUserInfo().getTenant(), serviceName, localeString);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EDMX_READ_FAILED, new Object[]{serviceName, t});
        }
    }
}

