/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.LimitLookup;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v4.query.apply.ApplyHandler;
import com.sap.cds.adapter.odata.v4.query.apply.LimitCalculator;
import com.sap.cds.adapter.odata.v4.query.apply.OrderByTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.SearchTransformation;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;

public class SystemQueryLoader {
    private static final TenantAwareCache<LimitLookup, CdsModel> limitLookup = TenantAwareCache.create(() -> CdsRequestGlobals.currentContext().getUserInfo().getTenant(), LimitLookup::new, () -> CdsRequestGlobals.currentContext().getModel());
    private NextLinkInfo nextLinkInfo;

    private SystemQueryLoader() {
    }

    public static SystemQueryLoader queryLoader() {
        return new SystemQueryLoader();
    }

    public NextLinkInfo getNextLinkInfo() {
        return this.nextLinkInfo;
    }

    public List<Select<?>> updateSelectQuery(Select<?> select, UriInfo uriInfo, boolean limit, CdsService service, CdsEntity entity) {
        this.nextLinkInfo = null;
        select.columns(Arrays.asList(CqnStar.star()));
        ApplyHandler applyHandler = ApplyHandler.create(uriInfo.getApplyOption());
        if (applyHandler.hasConcat()) {
            this.rejectOtherSystemQueryOptions(uriInfo);
        }
        List<Select<?>> selects = applyHandler.transform(select);
        selects.forEach(s -> this.applySystemQueryOptions((Select<?>)s, uriInfo, limit, service, entity));
        return selects;
    }

    private void rejectOtherSystemQueryOptions(UriInfo uriInfo) {
        uriInfo.getSystemQueryOptions().stream().map(SystemQueryOption::getKind).filter(k -> k != SystemQueryOptionKind.APPLY && k != SystemQueryOptionKind.FORMAT).findAny().ifPresent(k -> {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_CONCAT_SYSTEMQUERY, new Object[]{k.toString()});
        });
    }

    protected void applySystemQueryOptions(Select<?> select, UriInfo uriInfo, boolean limit, CdsService service, CdsEntity entity) {
        if (limit) {
            int maxTop;
            int top = Integer.MAX_VALUE;
            int skip = 0;
            if (uriInfo.getTopOption() != null) {
                top = uriInfo.getTopOption().getValue();
            }
            if (uriInfo.getSkipTokenOption() != null) {
                skip = Integer.parseInt(uriInfo.getSkipTokenOption().getValue());
            } else if (uriInfo.getSkipOption() != null) {
                skip = uriInfo.getSkipOption().getValue();
            }
            boolean serverDrivenPaging = false;
            int defaultTop = ((LimitLookup)limitLookup.findOrCreate()).getDefaultValue(service, entity);
            if (defaultTop > 0 && top == Integer.MAX_VALUE) {
                top = defaultTop;
                serverDrivenPaging = true;
            }
            if ((maxTop = ((LimitLookup)limitLookup.findOrCreate()).getMaxValue(service, entity)) > 0 && top > maxTop) {
                top = maxTop;
                serverDrivenPaging = true;
            }
            if (top < Integer.MAX_VALUE || skip > 0) {
                LimitCalculator calc = LimitCalculator.of(select);
                calc.skip(skip);
                calc.top(top);
                select.limit(calc.top(), calc.skip());
                if (serverDrivenPaging) {
                    this.nextLinkInfo = new NextLinkInfo(top, skip);
                }
            }
        }
        if (uriInfo.getOrderByOption() != null) {
            select.orderBy(OrderByTransformation.convertOrderByOption(select.items(), uriInfo.getOrderByOption()));
        }
        if (uriInfo.getFilterOption() != null) {
            select.where((CqnPredicate)ExpressionParser.parseFilter(uriInfo.getFilterOption().getExpression()));
        }
        if (uriInfo.getSearchOption() != null) {
            select.search((CqnPredicate)SearchTransformation.convertSearchOption(uriInfo.getSearchOption()));
        }
        if (uriInfo.getCountOption() != null && uriInfo.getCountOption().getValue()) {
            select.inlineCount();
        }
    }

    public Select<?> updateSelectColumns(Select<?> select, UriInfo uriInfo, CdsEntity entity) {
        if (uriInfo.getSelectOption() != null) {
            Stream<CqnSelectListValue> items = select.items().stream().flatMap(sli -> SystemQueryLoader.unfold((CdsStructuredType)entity, sli));
            select.columns(SystemQueryLoader.reduce(items, SystemQueryLoader.getSelectColumns(uriInfo.getSelectOption(), entity)));
        }
        if (uriInfo.getExpandOption() != null) {
            select.columns(SystemQueryLoader.merge(select.items(), SystemQueryLoader.getExpandColumns(uriInfo.getExpandOption(), entity)));
        }
        return select;
    }

    public Select<?> updateSelect(Select<?> select, UriInfo uriInfo, boolean limit, CdsService service, CdsEntity entity) {
        select = this.updateSelectQuery(select, uriInfo, limit, service, entity).get(0);
        return this.updateSelectColumns(select, uriInfo, entity);
    }

    private static List<String> getSelectColumns(SelectOption selectOption, CdsEntity entity) {
        HashSet<String> items = new HashSet<String>();
        entity.keyElements().map(key -> key.getName()).forEach(items::add);
        CdsElement etagElement = ETagHelper.getETagElement(entity);
        if (etagElement != null) {
            items.add(etagElement.getName());
        }
        for (SelectItem selectItem : selectOption.getSelectItems()) {
            if (selectItem.isStar()) {
                items.clear();
                entity.nonAssociationElements().map(CdsElement::getName).forEach(items::add);
                break;
            }
            if (selectItem.getResourcePath() == null) continue;
            List uriResourceParts = selectItem.getResourcePath().getUriResourceParts();
            if (uriResourceParts.size() > 1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SELECT_PARSING_FAILED, new Object[0]);
            }
            items.add(((UriResource)uriResourceParts.get(0)).getSegmentValue());
        }
        return new ArrayList<String>(items);
    }

    private static List<CqnSelectListItem> getExpandColumns(ExpandOption expandOption, CdsEntity entity) {
        List expandItems = expandOption.getExpandItems();
        if (expandItems.size() == 1 && ((ExpandItem)expandItems.get(0)).isStar()) {
            return Collections.singletonList(CQL.to((String)"*").expand());
        }
        ArrayList<CqnSelectListItem> expands = new ArrayList<CqnSelectListItem>();
        for (ExpandItem expandItem : expandItems) {
            if (expandItem.isStar()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_EXPAND_STAR, new Object[0]);
            }
            for (UriResource uriResource : expandItem.getResourcePath().getUriResourceParts()) {
                if (!(uriResource instanceof UriResourceNavigation)) continue;
                StructuredType type = CQL.to((String)uriResource.getSegmentValue());
                CdsEntity navigationEntity = entity.getTargetOf(uriResource.getSegmentValue());
                List<CqnSelectListItem> items = navigationEntity.nonAssociationElements().map(e -> CQL.get((String)e.getName())).collect(Collectors.toList());
                if (expandItem.getSelectOption() != null) {
                    Stream<CqnSelectListValue> slvs = items.stream().flatMap(sli -> SystemQueryLoader.unfold((CdsStructuredType)navigationEntity, sli));
                    items = SystemQueryLoader.reduce(slvs, SystemQueryLoader.getSelectColumns(expandItem.getSelectOption(), navigationEntity));
                }
                if (expandItem.getFilterOption() != null) {
                    type.filter((CqnPredicate)ExpressionParser.parseFilter(expandItem.getFilterOption().getExpression()));
                }
                if (expandItem.getExpandOption() != null) {
                    items = SystemQueryLoader.merge(items, SystemQueryLoader.getExpandColumns(expandItem.getExpandOption(), navigationEntity));
                }
                Expand expand = type.expand(items);
                if (expandItem.getOrderByOption() != null) {
                    expand.orderBy(OrderByTransformation.convertOrderByOption(items, expandItem.getOrderByOption()));
                }
                int top = Integer.MAX_VALUE;
                int skip = 0;
                if (expandItem.getTopOption() != null) {
                    top = expandItem.getTopOption().getValue();
                }
                if (expandItem.getSkipOption() != null) {
                    skip = expandItem.getSkipOption().getValue();
                }
                if (top < Integer.MAX_VALUE || skip > 0) {
                    expand.limit((long)top, (long)skip);
                }
                expands.add((CqnSelectListItem)expand);
            }
        }
        return expands;
    }

    private static List<CqnSelectListItem> reduce(Stream<CqnSelectListValue> slvs, List<String> allowedColumns) {
        return slvs.filter(slv -> allowedColumns.contains(slv.displayName())).collect(Collectors.toList());
    }

    private static List<CqnSelectListItem> merge(List<CqnSelectListItem> columns, List<CqnSelectListItem> additionalColumns) {
        if (additionalColumns.isEmpty()) {
            return columns;
        }
        ArrayList<CqnSelectListItem> items = new ArrayList<CqnSelectListItem>(columns);
        for (CqnSelectListItem newItem : additionalColumns) {
            List<? extends CqnReference.Segment> newSegments = SystemQueryLoader.getSegments(newItem.token());
            items.stream().filter(c -> SystemQueryLoader.isMatching(c, newSegments)).findFirst().ifPresent(items::remove);
            items.add(newItem);
        }
        return items;
    }

    private static Stream<CqnSelectListValue> unfold(CdsStructuredType type, CqnSelectListItem sli) {
        if (sli.isValue()) {
            return Stream.of(sli.asValue());
        }
        if (sli.isStar()) {
            return type.nonAssociationElements().map(e -> CQL.get((String)e.getName()));
        }
        return Stream.empty();
    }

    private static boolean isMatching(CqnSelectListItem c, List<? extends CqnReference.Segment> newSegments) {
        List<? extends CqnReference.Segment> segments = SystemQueryLoader.getSegments(c.token());
        if (segments == null || newSegments == null || segments.size() != newSegments.size()) {
            return false;
        }
        for (int i = 0; i < segments.size(); ++i) {
            CqnReference.Segment segment = segments.get(i);
            CqnReference.Segment newSegment = newSegments.get(i);
            if (!segment.id().equals(newSegment.id())) {
                return false;
            }
            if (!(segment.filter().isPresent() ? !segment.toJson().equals(newSegment.toJson()) : newSegment.filter().isPresent())) continue;
            return false;
        }
        return true;
    }

    private static List<? extends CqnReference.Segment> getSegments(CqnToken token) {
        CqnValue value;
        if (token instanceof CqnReference) {
            return ((CqnReference)token).segments();
        }
        if (token instanceof Expand) {
            return ((Expand)token).ref().segments();
        }
        if (token instanceof CqnSelectListValue && (value = ((CqnSelectListValue)token).value()).isRef()) {
            return value.asRef().segments();
        }
        return null;
    }
}

