/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;

public class AggregateTransformation
implements Transformation {
    private static final String SINGLE_VALUE = "singleValue";
    private final Aggregate agg;
    private CdsModel model;

    public AggregateTransformation(Aggregate agg) {
        this.agg = agg;
        this.model = CdsRequestGlobals.currentContext().getModel();
    }

    @Override
    public Select<?> apply(Select<?> select) {
        ElementAggregator aggregator = new ElementAggregator(CqnStatementUtils.rowType((CdsModel)this.model, select));
        ArrayList<Object> items = new ArrayList<Object>();
        List agExps = this.agg.getExpressions();
        for (AggregateExpression agExp : agExps) {
            if (agExp.getInlineAggregateExpression() != null) {
                List uriResources = agExp.getPath();
                if (uriResources.size() > 2) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, uriResources.toArray());
                }
                StructuredType type = CQL.to((String)((UriResource)uriResources.get(0)).getSegmentValue());
                AggregateExpression inlineAgExp = agExp.getInlineAggregateExpression();
                List<CqnSelectListItem> selectList = aggregator.genericAggregate(inlineAgExp);
                items.add(type.expand(selectList));
                continue;
            }
            if (agExp.getExpression() != null) {
                items.addAll(aggregator.genericAggregate(agExp));
                continue;
            }
            items.add(aggregator.customAggregate(agExp));
        }
        select.items().stream().filter(i -> i.isSelectList()).forEach(items::add);
        select.columns(items);
        return select;
    }

    private String getAggregationMethodName(CdsElement element) {
        HashMap valueMap = (HashMap)CdsAnnotations.AGGREGATION_DEFAULT.getOrValue((CdsAnnotatable)element, new HashMap());
        String value = (String)valueMap.get("#");
        if (value != null) {
            return value;
        }
        boolean isCurrencyCode = CdsAnnotations.SEMANTICS_CURRENCY_CODE.isTrue((CdsAnnotatable)element);
        boolean isUnitOfMeasure = CdsAnnotations.SEMANTICS_UNIT_OF_MEASURE.isTrue((CdsAnnotatable)element);
        if (isCurrencyCode || isUnitOfMeasure) {
            return SINGLE_VALUE;
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_CUSTOM_AGGREGATE_DEFINED, new Object[]{element});
    }

    private static Value<?> virtualPropertyToFunc(String virtualProperty) {
        switch (virtualProperty) {
            case "$count": {
                return CQL.count();
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_METHOD, new Object[]{virtualProperty});
    }

    @Override
    public int rank() {
        return 2;
    }

    private class ElementAggregator {
        private final CdsStructuredType structType;

        ElementAggregator(CdsStructuredType structType) {
            this.structType = structType;
        }

        List<CqnSelectListItem> genericAggregate(AggregateExpression inlineAgExp) {
            ArrayList<CqnSelectListItem> items = new ArrayList<CqnSelectListItem>();
            if (inlineAgExp.getExpression() != null) {
                Value<?> value = ExpressionParser.parseValue(inlineAgExp.getExpression());
                AggregateExpression.StandardMethod standardMethod = inlineAgExp.getStandardMethod();
                Value<?> functionCall = this.toFunc(value, standardMethod);
                items.add((CqnSelectListItem)functionCall.as(inlineAgExp.getAlias()));
            }
            return items;
        }

        CqnSelectListItem customAggregate(AggregateExpression agExp) {
            String path = agExp.getPath().stream().map(p -> p.getSegmentValue()).collect(Collectors.joining("."));
            if (path.startsWith("$")) {
                return AggregateTransformation.virtualPropertyToFunc(path).as(agExp.getAlias());
            }
            ElementRef ref = CQL.get((String)path);
            CdsElement element = CdsModelUtils.element((CdsStructuredType)this.structType, (CqnElementRef)ref);
            String methodName = AggregateTransformation.this.getAggregationMethodName(element);
            if (AggregateTransformation.SINGLE_VALUE.equals(methodName)) {
                return CQL.func((String)methodName, (CqnValue[])new CqnValue[]{ref}).as(path);
            }
            return this.toFunc((Value<?>)ref, AggregateExpression.StandardMethod.valueOf((String)methodName)).as(path);
        }

        private Value<?> toFunc(Value<?> value, AggregateExpression.StandardMethod standardMethod) {
            Value functionCall;
            switch (standardMethod) {
                case AVERAGE: {
                    functionCall = CQL.average(value);
                    break;
                }
                case COUNT_DISTINCT: {
                    functionCall = CQL.countDistinct(value);
                    break;
                }
                case MIN: {
                    functionCall = CQL.min(value);
                    this.type(value).ifPresent(arg_0 -> ((Value)functionCall).type(arg_0));
                    break;
                }
                case MAX: {
                    functionCall = CQL.max(value);
                    this.type(value).ifPresent(arg_0 -> ((Value)functionCall).type(arg_0));
                    break;
                }
                default: {
                    functionCall = CQL.func((String)standardMethod.name(), (CqnValue[])new CqnValue[]{value});
                }
            }
            return functionCall;
        }

        private Optional<CdsBaseType> type(Value<?> value) {
            CdsElement element;
            CdsType t;
            if (value.isRef() && (t = (element = CdsModelUtils.element((CdsStructuredType)this.structType, (CqnElementRef)value.asRef())).getType()).isSimple()) {
                return Optional.ofNullable(((CdsSimpleType)t.as(CdsSimpleType.class)).getType());
            }
            return Optional.empty();
        }
    }
}

