/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.utils.MessagesUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.ex.ODataErrorDetail;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;

public class ODataUtils {
    public static ODataSerializer createSerializer(OData odata, ODataRequest odataRequest, ContentType responseFormat) {
        try {
            return odata.createSerializer(responseFormat, Arrays.asList(ODataUtils.getODataVersion(odataRequest)));
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[]{e});
        }
    }

    public static EdmAssistedSerializer createSerializerForApply(OData odata, ContentType responseFormat) {
        try {
            return odata.createEdmAssistedSerializer(responseFormat);
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[]{e});
        }
    }

    public static String getODataVersion(ODataRequest odataRequest) {
        String odataVersion = odataRequest.getHeader("OData-Version");
        String odataMaxVersion = odataRequest.getHeader("OData-MaxVersion");
        return ODataUtils.getODataVersion(odataVersion, odataMaxVersion);
    }

    public static String getODataVersion(String odataVersion, String odataMaxVersion) {
        String version;
        String string = version = odataVersion != null && ODataServiceVersion.isValidODataVersion((String)odataVersion) ? odataVersion : "4.01";
        if (odataMaxVersion != null && ODataServiceVersion.isValidMaxODataVersion((String)odataMaxVersion) && Double.parseDouble(odataMaxVersion) < Double.parseDouble(version)) {
            version = odataMaxVersion;
        }
        return version;
    }

    public static void setODataErrorResponse(OData odata, ODataRequest odataRequest, ODataResponse odataResponse, CdsODataResponse cdsResponse, Messages messages, ContentType responseFormat) {
        ODataServerError serverError = new ODataServerError();
        serverError.setCode(cdsResponse.getErrorCode());
        serverError.setStatusCode(cdsResponse.getStatusCode());
        serverError.setMessage(cdsResponse.getErrorMessage());
        serverError.setTarget(MessagesUtils.getTarget(cdsResponse.getErrorTarget()));
        List details = messages.stream().map(m -> {
            ODataErrorDetail errorDetail = new ODataErrorDetail();
            errorDetail.setCode(MessagesUtils.getMessageCode(m));
            errorDetail.setMessage(m.getMessage());
            errorDetail.setTarget(MessagesUtils.getTarget(m.getTarget()));
            HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
            additionalProperties.put("@Common.numericSeverity", m.getSeverity().getNumericSeverity());
            if (m.getLongTextUrl() != null) {
                additionalProperties.put("@Common.longtextUrl", m.getLongTextUrl());
            }
            errorDetail.setAdditionalProperties(additionalProperties);
            return errorDetail;
        }).collect(Collectors.toList());
        if (!details.isEmpty()) {
            serverError.setDetails(details);
        }
        odataResponse.setStatusCode(cdsResponse.getStatusCode());
        odataResponse.setHeader("Content-Type", responseFormat.toContentTypeString());
        odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(odataRequest));
        try {
            odataResponse.setContent(ODataUtils.createSerializer(odata, odataRequest, responseFormat).error(serverError).getContent());
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
        }
    }
}

