/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.util.CdsTypeUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;

public class TypeConverterUtils {
    public static Object convertToType(EdmType type, String value) {
        Object typedValue;
        if (value == null) {
            return null;
        }
        Object theType = type.getKind() == EdmTypeKind.ENUM ? ((EdmEnumType)type).getUnderlyingType() : (type.getKind() == EdmTypeKind.DEFINITION ? ((EdmTypeDefinition)type).getUnderlyingType() : type);
        switch (theType.toString()) {
            case "Edm.Decimal": {
                typedValue = new BigDecimal(value);
                break;
            }
            case "Edm.Double": {
                typedValue = Double.parseDouble(value);
                break;
            }
            case "Edm.Single": {
                typedValue = Float.valueOf(Float.parseFloat(value));
                break;
            }
            case "Edm.Int64": {
                typedValue = Long.parseLong(value);
                break;
            }
            case "Edm.Int32": 
            case "Edm.Int16": 
            case "System.Uint7": 
            case "Edm.Byte": 
            case "Edm.SByte": {
                typedValue = Integer.parseInt(value);
                break;
            }
            case "Edm.Binary": {
                typedValue = value.getBytes(Charset.defaultCharset());
                break;
            }
            case "Edm.String": {
                if (value.length() >= 2 && value.startsWith("'") && value.endsWith("'")) {
                    typedValue = value.substring(1, value.length() - 1);
                    break;
                }
                typedValue = value;
                break;
            }
            case "Edm.TimeOfDay": {
                typedValue = LocalTime.parse(value);
                break;
            }
            case "Edm.Date": {
                typedValue = LocalDate.parse(value);
                break;
            }
            case "Edm.DateTimeOffset": {
                typedValue = ZonedDateTime.parse(value).toInstant();
                break;
            }
            case "Edm.Boolean": {
                typedValue = Boolean.parseBoolean(value);
                break;
            }
            case "Edm.Guid": {
                typedValue = CdsTypeUtils.parseUuid((Object)value);
                break;
            }
            default: {
                typedValue = value;
            }
        }
        return typedValue;
    }

    public static Object getValueBasedOnTypeOfResultSet(EdmType type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.toString()) {
            case "Edm.Guid": {
                value = UUID.fromString(value.toString());
                break;
            }
            case "Edm.DateTimeOffset": 
            case "Edm.Date": 
            case "Edm.TimeOfDay": {
                if (!(value instanceof String)) break;
                value = TypeConverterUtils.convertToType(type, (String)value);
                break;
            }
        }
        return value;
    }

    public static Object getValueBasedOnTypeOfRequestPayload(String typeName, Object value) {
        if (typeName != null) {
            switch (typeName) {
                case "Edm.Guid": {
                    if (!(value instanceof UUID)) break;
                    value = value.toString();
                    break;
                }
                case "Edm.DateTimeOffset": {
                    if (!(value instanceof Timestamp)) break;
                    value = ((Timestamp)value).toInstant();
                    break;
                }
                case "Edm.Date": {
                    if (!(value instanceof GregorianCalendar)) break;
                    value = ((GregorianCalendar)value).toZonedDateTime().toLocalDate();
                    break;
                }
                case "Edm.TimeOfDay": {
                    if (!(value instanceof GregorianCalendar)) break;
                    value = ((GregorianCalendar)value).toZonedDateTime().toLocalTime();
                    break;
                }
            }
        }
        return value;
    }
}

