/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.mtx;

import com.google.common.hash.Hashing;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.ODataEdmProvider;
import com.sap.cds.adapter.odata.v4.metadata.mtx.DefaultEdmxProviderAccessor;
import com.sap.cds.adapter.odata.v4.metadata.mtx.MtxEdmxProviderAccessor;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.mtx.MtxUtils;
import java.io.ByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEdmxProviderAccessor {
    private static Logger log = LoggerFactory.getLogger(AbstractEdmxProviderAccessor.class);
    protected static final String XML = ".xml";
    private static AbstractEdmxProviderAccessor defaultInstance;
    private static AbstractEdmxProviderAccessor instance;

    public static void initialize(CdsRuntime runtime) {
        defaultInstance = new DefaultEdmxProviderAccessor(runtime);
        if (new MtxUtils(runtime).mtxEnabled()) {
            instance = new MtxEdmxProviderAccessor(runtime);
            log.info("Initialized MTX EDMX V4 Provider");
        } else {
            instance = defaultInstance;
            log.info("Initialized Default EDMX V4 Provider");
        }
    }

    public static AbstractEdmxProviderAccessor getInstance() {
        if (defaultInstance == instance || CdsRequestGlobals.currentContext().getUserInfo().getTenant() == null) {
            return defaultInstance;
        }
        return instance;
    }

    public ODataEdmProvider getEdmxMetadataProvider(String serviceName) {
        return this.getMetadataInfo(serviceName).getEdmxMetadataProvider();
    }

    public String getMetadataEtag(String serviceName) {
        return this.getMetadataInfo(serviceName).getEtag();
    }

    protected abstract MetadataInfo getMetadataInfo(String var1);

    protected ODataEdmProvider loadMetadataFiles(String serviceName, byte[] edmxBytes) throws Exception {
        if (edmxBytes == null || edmxBytes.length == 0) {
            return null;
        }
        log.info("Loading OData V4 metadata for service '{}'", (Object)serviceName);
        ODataEdmProvider edmxMetadataProvider = new ODataEdmProvider(new ByteArrayInputStream(edmxBytes));
        if (!edmxMetadataProvider.isV4Metadata()) {
            throw new IllegalArgumentException("The provided bytes don't contain OData V4 Metadata");
        }
        return edmxMetadataProvider;
    }

    protected String calculateMetadataEtag(byte[] edmxBytes) {
        if (edmxBytes == null || edmxBytes.length == 0) {
            return null;
        }
        return Hashing.sha256().hashBytes(edmxBytes).toString();
    }
}

