/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.google.common.collect.Streams;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.query.SystemQueryLoader;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.TypeConverterUtils;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ListUtils;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CdsModelUtils;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CdsProcessor.class);
    private final CdsRequestGlobals globals;
    private static final Result NOT_MODIFIED = ResultBuilder.selectedRows(Collections.emptyList()).result();

    public CdsProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
    }

    public void processRequest(CdsODataRequest request, Consumer<CdsODataResponse> responseProcessor) {
        ChangeSetContext changeSetContext = ChangeSetContext.getCurrent();
        if (changeSetContext == null) {
            this.globals.getRuntime().changeSetContext().run(context -> {
                this.processRequest(request, responseProcessor, (ChangeSetContext)context);
                return null;
            });
        } else {
            this.processRequest(request, responseProcessor, changeSetContext);
        }
    }

    private void processRequest(CdsODataRequest cdsRequest, Consumer<CdsODataResponse> responseProcessor, ChangeSetContext changeSetContext) {
        boolean stackMessagesEnabled = this.globals.getRuntime().getEnvironment().getCdsProperties().getErrors().getStackMessages().isEnabled();
        this.globals.getRuntime().requestContext().clearMessages().parameters((ParameterInfo)cdsRequest).recalculateFeatureToggles().run(requestContext -> {
            CdsODataResponse response;
            try {
                response = this.delegateRequest(cdsRequest);
            }
            catch (ServiceException e) {
                this.markForCancel(changeSetContext, e);
                if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                    logger.error(e.getMessage(), (Throwable)e);
                } else {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                response = new CdsODataResponse(e.getErrorStatus(), e.getMessageTarget(), e.getLocalizedMessage(), stackMessagesEnabled);
            }
            catch (Throwable e) {
                this.markForCancel(changeSetContext, e);
                logger.error(e.getMessage(), e);
                response = new CdsODataResponse((ErrorStatus)ErrorStatuses.SERVER_ERROR, null, new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(), stackMessagesEnabled);
            }
            try {
                responseProcessor.accept(response);
            }
            catch (Throwable e) {
                this.markForCancel(changeSetContext, e);
                throw e;
            }
        });
    }

    private void markForCancel(ChangeSetContext changeSet, Throwable e) {
        changeSet.markForCancel();
        logger.info("Exception marked the ChangeSet {} as cancelled: {}", (Object)changeSet.getId(), (Object)e.getMessage());
    }

    private CdsODataResponse delegateRequest(CdsODataRequest request) {
        UriResource lastResource = request.getLastResource();
        HttpMethod method = request.getODataRequest().getMethod();
        UriResourceKind kind = lastResource.getKind();
        switch (kind) {
            case action: 
            case function: {
                return this.operation(request);
            }
            case primitiveProperty: 
            case complexProperty: 
            case value: {
                switch (method) {
                    case GET: {
                        return this.get(request);
                    }
                    case POST: {
                        boolean isCollection = false;
                        if (kind.equals((Object)UriResourceKind.complexProperty)) {
                            isCollection = ((UriResourceComplexProperty)lastResource).getProperty().isCollection();
                        } else if (kind.equals((Object)UriResourceKind.primitiveProperty)) {
                            isCollection = ((UriResourcePrimitiveProperty)lastResource).getProperty().isCollection();
                        }
                        if (isCollection) {
                            return this.patch(request);
                        }
                    }
                    case PUT: 
                    case DELETE: 
                    case PATCH: {
                        return this.patch(request);
                    }
                }
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
            }
        }
        switch (method) {
            case GET: {
                return this.get(request);
            }
            case POST: {
                return this.post(request);
            }
            case PUT: {
                return this.put(request);
            }
            case DELETE: {
                return this.delete(request);
            }
            case PATCH: {
                return this.patch(request);
            }
        }
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    private CdsODataResponse get(CdsODataRequest request) {
        Result result;
        boolean readById;
        ApplicationService applicationService = this.globals.getApplicationService();
        String qualifiedEntityName = request.getLastEntityName();
        CdsEntity cdsEntity = this.globals.getModel().getEntity(qualifiedEntityName);
        CdsService cdsServiceModel = applicationService.getDefinition();
        String contentType = null;
        String contentDispoFilename = null;
        UriResource lastResource = request.getLastResource();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        UriInfo uriInfo = request.getUriInfo();
        Select<?> select = Select.from(this.toPathExpression(uriInfo.getUriResourceParts(), parameters));
        SystemQueryLoader queryLoader = SystemQueryLoader.queryLoader();
        List<Select<?>> selects = queryLoader.updateSelectQuery(select, request.getUriInfo(), true, cdsServiceModel, cdsEntity);
        String mediaTypeElementName = null;
        String contentDispoElementName = null;
        switch (lastResource.getKind()) {
            case primitiveProperty: {
                EdmProperty property = ((UriResourcePrimitiveProperty)lastResource).getProperty();
                if (property.getType().getFullQualifiedName().getFullQualifiedNameAsString().equals("Edm.Stream")) {
                    ArrayList<Object> columns = new ArrayList<Object>();
                    columns.add(CQL.get((String)property.getName()));
                    mediaTypeElementName = CdsProcessor.getAnnotationElement(CdsAnnotations.CORE_MEDIA_TYPE, cdsEntity, property.getName());
                    if (!StringUtils.isEmpty((CharSequence)mediaTypeElementName)) {
                        columns.add(CdsProcessor.getSelectListItem(mediaTypeElementName));
                    } else {
                        contentType = CdsProcessor.getAnnotationValue(CdsAnnotations.CORE_MEDIA_TYPE, cdsEntity, property.getName());
                    }
                    contentDispoElementName = CdsProcessor.getAnnotationElement(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, cdsEntity, property.getName());
                    if (!StringUtils.isEmpty((CharSequence)contentDispoElementName)) {
                        columns.add(CdsProcessor.getSelectListItem(contentDispoElementName));
                    } else {
                        contentDispoFilename = CdsProcessor.getAnnotationValue(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, cdsEntity, property.getName());
                    }
                    select.columns(columns);
                    break;
                }
                select.columns(new String[]{property.getName()});
                break;
            }
            case complexProperty: {
                EdmProperty property = ((UriResourceComplexProperty)lastResource).getProperty();
                select.columns(new String[]{property.getName()});
                break;
            }
            case count: {
                select.columns(new CqnSelectListItem[]{CQL.count().as("count")});
                break;
            }
            case value: {
                UriResourcePartTyped lastTypedResource = request.getLastTypedResource();
                if (lastTypedResource.getKind() == UriResourceKind.primitiveProperty) {
                    select.columns(new String[]{((UriResourcePrimitiveProperty)lastTypedResource).getProperty().getName()});
                    break;
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{lastTypedResource.getKind()});
            }
            default: {
                select = queryLoader.updateSelectColumns(select, request.getUriInfo(), cdsEntity);
            }
        }
        CdsElement etagElement = ETagHelper.getETagElement(cdsEntity);
        boolean keysSpecified = false;
        if (select.from().isRef()) {
            AnalysisResult analysis = CqnAnalyzer.create((CdsModel)this.globals.getModel()).analyze(select.ref());
            long keyCount = analysis.targetEntity().keyElements().count();
            keysSpecified = keyCount > 0L && (long)analysis.targetKeyValues().size() == keyCount;
        }
        boolean bl = readById = keysSpecified || !request.getLastEntityResource(true).isCollection();
        if (readById) {
            result = this.readById(request, applicationService, qualifiedEntityName, parameters, selects.get(0), etagElement);
            if (result == NOT_MODIFIED) {
                return new CdsODataResponse(304, result);
            }
            if (!StringUtils.isEmpty((CharSequence)mediaTypeElementName)) {
                contentType = CdsProcessor.getStringValueFromResult(mediaTypeElementName, result);
            }
            if (!StringUtils.isEmpty((CharSequence)contentDispoElementName)) {
                contentDispoFilename = CdsProcessor.getStringValueFromResult(contentDispoElementName, result);
            }
        } else {
            boolean analyticsQuery = uriInfo.getApplyOption() != null;
            result = this.query(applicationService, parameters, selects, analyticsQuery);
        }
        return new CdsODataResponse(200, result, queryLoader.getNextLinkInfo(), contentType, contentDispoFilename);
    }

    private Result readById(CdsODataRequest request, ApplicationService applicationService, String qualifiedEntityName, Map<String, Object> parameters, Select<?> select, CdsElement etagElement) {
        if (etagElement != null && ETagHelper.isETagHeaderInRequest(request)) {
            if (ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request)) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
            select = (Select)CqnUtils.modifiedWhere(select, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement)));
        }
        Result result = applicationService.run(select, parameters);
        long rowCount = result.rowCount();
        if (etagElement != null && ETagHelper.isETagHeaderInRequest(request) && rowCount == 0L) {
            if (request.getHeader("If-None-Match") != null) {
                return NOT_MODIFIED;
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
        }
        if (rowCount == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{qualifiedEntityName, CdsModelUtils.getTargetKeysAsString((CdsModel)this.globals.getModel(), (CqnStatement)select)});
        }
        return result;
    }

    private Result query(ApplicationService applicationService, Map<String, Object> parameters, List<Select<?>> selects, boolean analyticsQuery) {
        ArrayList allRows = new ArrayList();
        long[] inlineCount = new long[selects.size()];
        for (int i = 0; i < selects.size(); ++i) {
            Select<?> select = selects.get(i);
            Result result = applicationService.run(select, parameters);
            inlineCount[i] = result.inlineCount();
            Stream<Row> rows = result.stream();
            if (analyticsQuery) {
                Set keys = select.items().stream().filter(sli -> sli.isValue()).map(sli -> sli.asValue().displayName()).collect(Collectors.toSet());
                rows = rows.peek(r -> CdsProcessor.addNullsForOmittedValues((Map<String, Object>)r, keys));
            }
            rows.forEach(allRows::add);
        }
        return ResultBuilder.selectedRows(allRows).inlineCount(inlineCount[0]).result();
    }

    private static void addNullsForOmittedValues(Map<String, Object> r, Set<String> keys) {
        for (String key : keys) {
            CdsProcessor.addNullForOmittedValue(r, key);
        }
    }

    private static void addNullForOmittedValue(Map<String, Object> r, String key) {
        int i = key.indexOf(46);
        if (i == -1) {
            if (!r.containsKey(key)) {
                r.put(key, null);
            }
        } else {
            String seg = key.substring(0, i);
            Map inner = (Map)r.computeIfAbsent(seg, s -> new HashMap());
            CdsProcessor.addNullForOmittedValue(inner, key.substring(i + 1));
        }
    }

    private CdsODataResponse post(CdsODataRequest request) {
        ApplicationService applicationService = this.globals.getApplicationService();
        StructuredType<?> ref = this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>());
        ref.filter((CqnPredicate)null);
        Insert insert = Insert.into(ref).entry(request.getBodyMap());
        String qualifiedEntityName = request.getLastEntityName();
        CdsEntity entity = this.globals.getModel().getEntity(qualifiedEntityName);
        Object isActiveEntity = request.getBodyMap().get("IsActiveEntity");
        Result result = DraftUtils.isDraftEnabled((CdsEntity)entity) && (isActiveEntity == null || (Boolean)isActiveEntity == false) ? ((DraftService)applicationService).newDraft((CqnInsert)insert) : applicationService.run((CqnInsert)insert);
        return new CdsODataResponse(201, result);
    }

    private CdsODataResponse put(CdsODataRequest request) {
        String qualifiedEntityName = request.getLastEntityName();
        CdsEntity rootEntity = this.globals.getModel().getEntity(qualifiedEntityName);
        DataUtils dataUtils = DataUtils.create(() -> SessionContextUtils.toSessionContext((RequestContext)RequestContext.getCurrent((CdsRuntime)this.globals.getRuntime())), (int)7);
        DataProcessor processor = DataProcessor.create().addGenerator((p, e, t) -> DataUtils.hasDefaultValue((CdsElement)e, (CdsType)t), (p, e, isNull) -> isNull ? null : dataUtils.defaultValue(e)).action(CdsProcessor::defaultToNull);
        processor.process(request.getBodyMap(), (CdsStructuredType)rootEntity);
        return this.patch(request);
    }

    private static void defaultToNull(CdsStructuredType type, Map<String, Object> data) {
        final ArrayList fkElements = new ArrayList();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnElementRef elementRef) {
                String name;
                if (elementRef.segments().size() == 1 && !"$self".equals(name = elementRef.firstSegment())) {
                    fkElements.add(name);
                }
            }
        };
        type.associations().map(e -> (CdsAssociationType)e.getType().as(CdsAssociationType.class)).map(a -> a.onCondition()).filter(o -> o.isPresent()).map(o -> (CqnPredicate)o.get()).forEach(p -> p.accept(visitor));
        type.elements().filter(e -> !e.isKey()).filter(e -> !e.getType().isAssociation()).filter(e -> CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrDefault((CdsAnnotatable)e) == null).filter(e -> !fkElements.contains(e.getName())).forEach(e -> data.putIfAbsent(e.getName(), null));
    }

    private CdsODataResponse patch(CdsODataRequest request) {
        ApplicationService applicationService = this.globals.getApplicationService();
        String qualifiedEntityName = request.getLastEntityName();
        CdsEntity cdsEntity = this.globals.getModel().getEntity(qualifiedEntityName);
        StructuredType<?> ref = this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>());
        AnalysisResult analysis = CqnAnalyzer.create((CdsModel)this.globals.getModel()).analyze((CqnStructuredTypeRef)ref.asRef());
        request.getBodyMap().putAll(analysis.targetKeyValues());
        Map<String, Object> bodyMap = request.getBodyMap();
        boolean isStreamProperty = false;
        UriResource lastResource = request.getLastResource();
        EdmProperty property = null;
        if (lastResource instanceof UriResourcePrimitiveProperty) {
            property = ((UriResourcePrimitiveProperty)lastResource).getProperty();
            if (property.getType().getFullQualifiedName().getFullQualifiedNameAsString().equals("Edm.Stream")) {
                isStreamProperty = true;
                String contentType = request.getHeader("Content-Type");
                String mediaTypeElement = CdsProcessor.getAnnotationElement(CdsAnnotations.CORE_MEDIA_TYPE, cdsEntity, property.getName());
                if (mediaTypeElement != null) {
                    bodyMap.put(mediaTypeElement, contentType);
                }
            }
        } else if (lastResource instanceof UriResourceComplexProperty) {
            property = ((UriResourceComplexProperty)lastResource).getProperty();
        }
        if (property != null && property.isCollection() && request.getODataRequest().getMethod().equals((Object)HttpMethod.POST)) {
            CdsODataResponse cdsODataResponse = this.get(request);
            Row row = cdsODataResponse.getResult().single();
            List existingValues = (List)row.get((Object)property.getName());
            List addedValues = (List)bodyMap.get(property.getName());
            existingValues.addAll(addedValues);
            bodyMap.put(property.getName(), existingValues);
        }
        Update update = Update.entity(ref).data(bodyMap);
        CdsElement etagElement = ETagHelper.getETagElement(cdsEntity);
        if (etagElement != null) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                update = (CqnUpdate)CqnUtils.modifiedWhere((CqnStatement)update, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement)));
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
        Result updateResult = this.draftEvent(update.ref(), cdsEntity, this.globals.getModel()) ? ((DraftService)applicationService).patchDraft((CqnUpdate)update, new Object[0]) : applicationService.run((CqnUpdate)update, new Object[0]);
        long rowCount = updateResult.rowCount();
        if (etagElement != null) {
            boolean ifNoneMatchAsterisk = ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request);
            if (rowCount == 0L && !ifNoneMatchAsterisk || rowCount > 0L && ifNoneMatchAsterisk) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
        }
        if (rowCount == 0L) {
            if (lastResource instanceof UriResourcePrimitiveProperty || lastResource instanceof UriResourceValue) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{qualifiedEntityName, CdsModelUtils.getTargetKeysAsString((CdsModel)this.globals.getModel(), (CqnStatement)update)});
            }
            return this.post(request);
        }
        if (request.getReturnPreference() != Preferences.Return.MINIMAL && !isStreamProperty) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Select<?> select = Select.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), parameters));
            select = SystemQueryLoader.queryLoader().updateSelect(select, request.getUriInfo(), false, null, cdsEntity);
            Result readResult = applicationService.run(select, parameters);
            return new CdsODataResponse(200, readResult);
        }
        Map targetKeys = CqnAnalyzer.create((CdsModel)this.globals.getModel()).analyze(update.ref()).targetKeyValues();
        updateResult.single().putAll(targetKeys);
        return new CdsODataResponse(204, updateResult);
    }

    private CdsODataResponse delete(CdsODataRequest request) {
        ApplicationService applicationService = this.globals.getApplicationService();
        Delete delete = Delete.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>()));
        String qualifiedEntityName = request.getLastEntityName();
        CdsEntity cdsEntity = this.globals.getModel().getEntity(qualifiedEntityName);
        CdsElement etagElement = ETagHelper.getETagElement(cdsEntity);
        if (etagElement != null) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                if (ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request)) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
                delete = (CqnDelete)CqnUtils.modifiedWhere((CqnStatement)delete, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement)));
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
        CdsEntity entity = this.globals.getModel().getEntity(qualifiedEntityName);
        Result result = this.draftEvent(delete.ref(), entity, this.globals.getModel()) ? ((DraftService)applicationService).cancelDraft((CqnDelete)delete, new Object[0]) : applicationService.run((CqnDelete)delete, new Object[0]);
        if (result.rowCount() == 0L) {
            if (etagElement != null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{qualifiedEntityName, CdsModelUtils.getTargetKeysAsString((CdsModel)this.globals.getModel(), (CqnStatement)delete)});
        }
        return new CdsODataResponse(204);
    }

    private CdsODataResponse operation(CdsODataRequest request) {
        EdmType returnType;
        Result result;
        block14: {
            EventContext context;
            EdmAction operation;
            UriResource lastResource = request.getLastResource();
            if (lastResource.getKind() == UriResourceKind.action) {
                operation = ((UriResourceAction)lastResource).getAction();
            } else if (lastResource.getKind() == UriResourceKind.function) {
                operation = ((UriResourceFunction)lastResource).getFunction();
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{lastResource.getKind()});
            }
            if (operation.isBound()) {
                String qualifiedEntityName = request.getLastEntityName();
                CdsEntity cdsEntity = this.globals.getModel().getEntity(qualifiedEntityName);
                this.validateETagForWriteWithSelect(request, cdsEntity);
                context = EventContext.create((String)operation.getName(), (String)qualifiedEntityName);
                context.put("cqn", (Object)Select.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>())));
            } else {
                context = EventContext.create((String)operation.getName(), null);
            }
            request.getBodyMap().forEach((key, value) -> context.put(key, value));
            this.globals.getApplicationService().emit(context);
            result = null;
            Object returnValue = context.get("result");
            EdmType edmType = returnType = operation.getReturnType() == null ? null : operation.getReturnType().getType();
            if (returnValue != null) {
                try {
                    if (returnType instanceof EdmPrimitiveType) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put(operation.getName(), returnValue);
                        result = ResultUtils.convert((Iterable)ListUtils.getList((Object[])new Map[]{data}));
                        break block14;
                    }
                    if (returnValue instanceof Iterable) {
                        result = ResultUtils.convert((Iterable)((Iterable)returnValue));
                        break block14;
                    }
                    if (returnValue instanceof Map) {
                        result = ResultUtils.convert((Iterable)ListUtils.getList((Object[])new Map[]{(Map)returnValue}));
                        break block14;
                    }
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{returnValue.getClass().getName()});
                }
                catch (ClassCastException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{returnValue.getClass().getName(), e});
                }
            }
        }
        if (returnType instanceof EdmEntityType && result != null) {
            EdmEntityType entityReturnType = (EdmEntityType)returnType;
            if (!this.matchesSelectExpand(result.list(), entityReturnType, request.getUriInfo().getSelectOption(), request.getUriInfo().getExpandOption())) {
                ApplicationService applicationService = this.globals.getApplicationService();
                String qualifiedEntityName = EdmUtils.getCdsEntityName(entityReturnType, this.globals.getCdsEntityNames());
                CdsEntity cdsEntity = this.globals.getModel().getEntity(qualifiedEntityName);
                Select<?> select = Select.from((StructuredType)CQL.entity((String)qualifiedEntityName));
                select = SystemQueryLoader.queryLoader().updateSelect(select, request.getUriInfo(), false, null, cdsEntity);
                List entityKeys = entityReturnType.getKeyPredicateNames();
                CqnSelect additionalSelect = (CqnSelect)CqnUtils.modifiedWhere(select, (Function)CqnUtils.andPredicate((CqnPredicate)this.fetchKeyValuesFromResult(result, entityKeys)));
                result = applicationService.run(additionalSelect, new Object[0]);
            }
        }
        return new CdsODataResponse(200, result);
    }

    private boolean matchesSelectExpand(List<? extends Map<?, ?>> result, EdmEntityType type, SelectOption selectOption, ExpandOption expandOption) {
        boolean matches = true;
        if (selectOption != null) {
            matches = selectOption.getSelectItems().stream().allMatch(selectItem -> {
                if (selectItem.isStar()) {
                    return result.stream().allMatch(map -> map.keySet().containsAll(type.getPropertyNames()));
                }
                if (selectItem.getResourcePath() != null) {
                    List uriResources = selectItem.getResourcePath().getUriResourceParts();
                    if (uriResources.size() > 1) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SELECT_PARSING_FAILED, new Object[0]);
                    }
                    String selectProperty = ((UriResource)uriResources.get(0)).getSegmentValue();
                    return result.stream().allMatch(map -> map.containsKey(selectProperty));
                }
                return true;
            });
        }
        if (matches && expandOption != null) {
            matches = expandOption.getExpandItems().stream().allMatch(expandItem -> {
                if (expandItem.isStar()) {
                    return result.stream().allMatch(map -> map.keySet().containsAll(type.getNavigationPropertyNames()));
                }
                if (expandItem.getResourcePath() != null) {
                    List uriResources = expandItem.getResourcePath().getUriResourceParts();
                    String expandProperty = ((UriResource)uriResources.get(uriResources.size() - 1)).getSegmentValue();
                    boolean expandItemMatches = result.stream().allMatch(map -> map.containsKey(expandProperty));
                    if (expandItemMatches) {
                        EdmEntityType expandType = type.getNavigationProperty(expandProperty).getType();
                        List expandResult = result.stream().map(map -> map.get(expandProperty)).flatMap(v -> {
                            if (v instanceof Map) {
                                return Stream.of((Map)v);
                            }
                            if (v instanceof Iterable) {
                                return Streams.stream((Iterable)((Iterable)v));
                            }
                            return Stream.empty();
                        }).collect(Collectors.toList());
                        return this.matchesSelectExpand(expandResult, expandType, expandItem.getSelectOption(), expandItem.getExpandOption());
                    }
                    return false;
                }
                return true;
            });
        }
        return matches;
    }

    private Predicate fetchKeyValuesFromResult(Result result, List<String> entityKeys) {
        Predicate predicate = null;
        for (String keyName : entityKeys) {
            List keyValues = result.stream().map(map -> map.get((Object)keyName)).collect(Collectors.toList());
            Predicate keyPredicate = CQL.get((String)keyName).in(keyValues);
            predicate = predicate == null ? keyPredicate : predicate.and((CqnPredicate)keyPredicate, new CqnPredicate[0]);
        }
        return predicate;
    }

    private StructuredType<?> toPathExpression(List<UriResource> uriResources, Map<String, Object> parameters) {
        UriResource resource;
        if (uriResources.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_URI_RESOURCE, new Object[0]);
        }
        StructuredType parent = null;
        UriResource rootResource = uriResources.get(0);
        if (rootResource instanceof UriResourceEntitySet) {
            UriResourceEntitySet rootEntitySetResource = (UriResourceEntitySet)rootResource;
            Map<String, Object> keys = this.getFilterKeys(rootEntitySetResource.getKeyPredicates(), rootEntitySetResource.getEntityType().getKeyPropertyRefs());
            if (EdmUtils.isParametersEntityType(rootEntitySetResource.getEntityType())) {
                parameters.putAll(keys);
            } else {
                String entityName = EdmUtils.getCdsEntityName(rootEntitySetResource.getEntityType(), this.globals.getCdsEntityNames());
                parent = CQL.entity((String)entityName).matching(keys);
            }
        } else if (rootResource instanceof UriResourceSingleton) {
            UriResourceSingleton rootSingletonResource = (UriResourceSingleton)rootResource;
            parent = CQL.entity((String)EdmUtils.getCdsEntityName(rootSingletonResource.getEntityType(), this.globals.getCdsEntityNames()));
        } else {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{rootResource.getKind()});
        }
        for (int i = 1; i < uriResources.size() && (resource = uriResources.get(i)) instanceof UriResourceNavigation; ++i) {
            UriResourceNavigation navigationResource = (UriResourceNavigation)resource;
            EdmEntityType navigationType = navigationResource.getProperty().getType();
            Map<String, Object> keys = this.getFilterKeys(navigationResource.getKeyPredicates(), navigationType.getKeyPropertyRefs());
            if (EdmUtils.isParametersEntityType(navigationType)) {
                parameters.putAll(keys);
                continue;
            }
            String entityName = EdmUtils.getCdsEntityName(navigationType, this.globals.getCdsEntityNames());
            parent = parent == null ? CQL.entity((String)entityName).matching(keys) : parent.to(navigationResource.getSegmentValue()).matching(keys);
        }
        if (parent == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PARAMETERIZED_VIEW, new Object[0]);
        }
        return parent;
    }

    private Map<String, Object> getFilterKeys(List<UriParameter> keyPreds, List<EdmKeyPropertyRef> keyRefs) {
        Map<String, EdmType> elementTypes = keyRefs.stream().collect(Collectors.toMap(k -> k.getName(), k -> k.getProperty().getType()));
        HashMap<String, Object> keys = new HashMap<String, Object>();
        for (UriParameter key : keyPreds) {
            String name = key.getName();
            keys.put(name, TypeConverterUtils.convertToType(elementTypes.get(name), key.getText()));
        }
        return keys;
    }

    private void validateETagForWriteWithSelect(CdsODataRequest request, CdsEntity cdsEntity) {
        CdsElement etagElement = ETagHelper.getETagElement(cdsEntity);
        if (etagElement != null) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                Select select = Select.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), parameters));
                CqnSelect etagSelect = (CqnSelect)CqnUtils.modifiedWhere((CqnStatement)select, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement)));
                Result queryResult = (Result)this.globals.getRuntime().requestContext().clearMessages().run(requestContext -> this.globals.getApplicationService().run(etagSelect, parameters));
                long rowCount = queryResult.rowCount();
                boolean ifNoneMatchAsterisk = ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request);
                if (rowCount == 0L && !ifNoneMatchAsterisk || rowCount > 0L && ifNoneMatchAsterisk) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
    }

    private boolean draftEvent(CqnStructuredTypeRef ref, CdsEntity entity, CdsModel model) {
        Map targetKeys = CqnAnalyzer.create((CdsModel)model).analyze(ref).targetKeyValues();
        return DraftUtils.isDraftEnabled((CdsEntity)entity) && targetKeys.containsKey("IsActiveEntity") && (Boolean)targetKeys.get("IsActiveEntity") == false;
    }

    private static String getAnnotationElement(CdsAnnotations annotation, CdsEntity cdsEntity, String propertyName) {
        Object annotationValues;
        String value = null;
        CdsElement element = cdsEntity.findElement(propertyName).orElse(null);
        if (element != null && (annotationValues = annotation.getOrDefault((CdsAnnotatable)element)) instanceof Map) {
            value = (String)((Map)annotationValues).get("=");
        }
        return value;
    }

    private static String getAnnotationValue(CdsAnnotations annotation, CdsEntity cdsEntity, String propertyName) {
        Object annotationValues;
        String value = null;
        CdsElement element = cdsEntity.findElement(propertyName).orElse(null);
        if (element != null && (annotationValues = annotation.getOrDefault((CdsAnnotatable)element)) instanceof String) {
            value = (String)annotationValues;
        }
        return value;
    }

    protected static CqnSelectListItem getSelectListItem(String elementPath) {
        if (StringUtils.isEmpty((CharSequence)elementPath)) {
            return null;
        }
        String[] segments = elementPath.split("\\.");
        int length = segments.length;
        if (length == 1) {
            return CQL.get((String)segments[0]);
        }
        if (length == 2) {
            return CQL.to((String)segments[0]).expand(new String[]{segments[1]});
        }
        Expand expand = CQL.to((String)segments[length - 2]).expand(new String[]{segments[length - 1]});
        for (int i = length - 3; i >= 0; --i) {
            expand = CQL.to((String)segments[i]).expand(new CqnSelectListItem[]{expand});
        }
        return expand;
    }

    private static String getStringValueFromResult(String elementPath, Result result) {
        if (StringUtils.isEmpty((CharSequence)elementPath)) {
            return null;
        }
        Iterator iter = Stream.of(elementPath.split("\\.")).iterator();
        String elementName = (String)iter.next();
        Object value = result.first().map(r -> r.get((Object)elementName)).orElse(null);
        while (value instanceof Map && iter.hasNext()) {
            value = ((Map)value).get(iter.next());
        }
        return value;
    }
}

