/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.ODataProcessor;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.prefer.PreferencesApplied;
import org.apache.olingo.server.api.processor.ActionComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionComplexProcessor;
import org.apache.olingo.server.api.processor.ActionEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionEntityProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveProcessor;
import org.apache.olingo.server.api.processor.ActionVoidProcessor;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.api.processor.ComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.CountEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.ErrorProcessor;
import org.apache.olingo.server.api.processor.PrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.PrimitiveValueProcessor;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlingoProcessor
implements EntityProcessor,
CountEntityCollectionProcessor,
ActionEntityProcessor,
ActionEntityCollectionProcessor,
PrimitiveValueProcessor,
PrimitiveCollectionProcessor,
ActionPrimitiveProcessor,
ActionPrimitiveCollectionProcessor,
ComplexProcessor,
ComplexCollectionProcessor,
ActionComplexProcessor,
ActionComplexCollectionProcessor,
ActionVoidProcessor,
BatchProcessor,
ErrorProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OlingoProcessor.class);
    private static final Logger accessLogger = LoggerFactory.getLogger((String)"com.sap.cds.adapter.odata.v4.BatchAccess");
    private static final String[] batchHeaderPropagation = new String[]{"OData-Version", "OData-MaxVersion", "Authorization"};
    private final CdsRequestGlobals globals;
    private final ODataProcessor odataProcessor;

    public OlingoProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.odataProcessor = new ODataProcessor(globals);
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
    }

    public void readEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleEntityRequest(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readEntityCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionEntityRequest(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void countEntityCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.handleUnsupportedOptions(uriInfo.asUriInfoResource());
        this.odataProcessor.processCountRequest(odataRequest, odataResponse, uriInfo);
    }

    private void handleUnsupportedOptions(UriInfoResource uriInfo) {
        if (uriInfo.getApplyOption() != null) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }
    }

    public void readComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleComplexRequest(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionComplexRequest(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readPrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitiveRequest(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readPrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitiveValueRequest(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readPrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionPrimitiveRequest(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void createEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleEntityRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleEntityRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionEntityCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionEntityRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleComplexRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionComplexRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionPrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitiveRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionPrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionPrimitiveRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionVoid(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, requestFormat);
    }

    public void updateEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleEntityRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void updateComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    public void updateComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionComplexRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void updatePrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitiveRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void updatePrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitiveValueRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void updatePrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionPrimitiveRequest(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void deleteEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deleteComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    public void deleteComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deletePrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deletePrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deletePrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void processBatch(BatchFacade facade, ODataRequest odataRequest, ODataResponse odataResponse) throws ODataApplicationException, ODataLibraryException {
        boolean continueOnError = this.globals.getOData().createPreferences((Collection)odataRequest.getHeaders("Prefer")).hasContinueOnError();
        String boundary = facade.extractBoundaryFromContentType(odataRequest.getHeader("Content-Type"));
        BatchOptions options = BatchOptions.with().rawBaseUri(odataRequest.getRawBaseUri()).rawServiceResolutionUri(odataRequest.getRawServiceResolutionUri()).build();
        List parts = this.globals.getOData().createFixedFormatDeserializer().parseBatchRequest(odataRequest.getBody(), boundary, options);
        ArrayList<ODataResponsePart> responseParts = new ArrayList<ODataResponsePart>();
        block0: for (BatchRequestPart part : parts) {
            for (ODataRequest req : part.getRequests()) {
                for (String header : batchHeaderPropagation) {
                    String parentHeader;
                    if (!StringUtils.isEmpty((String)req.getHeader(header)) || StringUtils.isEmpty((String)(parentHeader = odataRequest.getHeader(header)))) continue;
                    req.addHeader(header, parentHeader);
                }
            }
            ODataResponsePart responsePart = facade.handleBatchRequest(part);
            OlingoProcessor.logBatchRequest(part, responsePart);
            responseParts.add(responsePart);
            if (continueOnError) continue;
            for (ODataResponse response : responsePart.getResponses()) {
                int statusCode = response.getStatusCode();
                if (statusCode < 400 || statusCode > 600) continue;
                break block0;
            }
        }
        InputStream responseContent = this.globals.getOData().createFixedFormatSerializer().batchResponse(responseParts, boundary);
        odataResponse.setHeader("Content-Type", ContentType.MULTIPART_MIXED + ";boundary=" + boundary);
        odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(odataRequest));
        odataResponse.setContent(responseContent);
        odataResponse.setStatusCode(HttpStatusCode.OK.getStatusCode());
        if (continueOnError) {
            odataResponse.setHeader("Preference-Applied", PreferencesApplied.with().continueOnError().build().toValueString());
        }
    }

    public ODataResponsePart processChangeSet(BatchFacade facade, List<ODataRequest> odataRequests) throws ODataApplicationException, ODataLibraryException {
        try {
            return (ODataResponsePart)this.globals.getRuntime().changeSetContext().run(context -> {
                ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
                for (ODataRequest request : odataRequests) {
                    ODataResponse response;
                    try {
                        response = facade.handleODataRequest(request);
                    }
                    catch (ODataApplicationException | ODataLibraryException e) {
                        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
                    }
                    if (response.getStatusCode() >= 200 && response.getStatusCode() < 400) {
                        responses.add(response);
                        continue;
                    }
                    return new ODataResponsePart(response, false);
                }
                return new ODataResponsePart(responses, true);
            });
        }
        catch (Exception e) {
            ODataResponse errorResponse = new ODataResponse();
            this.processError(odataRequests.get(0), errorResponse, ODataExceptionHelper.createServerErrorObject((Exception)e), ContentType.APPLICATION_JSON);
            return new ODataResponsePart(errorResponse, false);
        }
    }

    public void processError(ODataRequest odataRequest, ODataResponse odataResponse, ODataServerError serverError, ContentType responseFormat) {
        boolean stackMessagesEnabled = this.globals.getRuntime().getEnvironment().getCdsProperties().getErrors().getStackMessages().isEnabled();
        Locale locale = RequestContext.getCurrent((CdsRuntime)this.globals.getRuntime()).getParameterInfo().getLocale();
        try {
            CdsODataResponse cdsResponse;
            Exception exception = serverError.getException();
            if (exception instanceof ServiceException) {
                ServiceException serviceException = (ServiceException)((Object)exception);
                cdsResponse = new CdsODataResponse(serviceException.getErrorStatus(), serviceException.getMessageTarget(), serviceException.getLocalizedMessage(locale), stackMessagesEnabled);
            } else {
                String message;
                ErrorStatus errorStatus = ErrorStatuses.getByCode((int)serverError.getStatusCode());
                if (errorStatus == null) {
                    errorStatus = ErrorStatuses.SERVER_ERROR;
                }
                if (StringUtils.isEmpty((String)(message = serverError.getMessage()))) {
                    message = new ErrorStatusException(errorStatus, new Object[0]).getLocalizedMessage(locale);
                }
                cdsResponse = new CdsODataResponse(errorStatus, null, message, stackMessagesEnabled);
            }
            if (cdsResponse.getStatusCode() >= 500 && cdsResponse.getStatusCode() < 600) {
                if (exception != null) {
                    logger.error(exception.getMessage(), (Throwable)exception);
                } else {
                    logger.error(serverError.getMessage());
                }
            } else if (exception != null) {
                logger.debug(exception.getMessage(), (Throwable)exception);
            } else {
                logger.error(serverError.getMessage());
            }
            odataResponse.getAllHeaders().keySet().stream().collect(Collectors.toList()).stream().forEach(k -> odataResponse.setHeader(k, ""));
            Messages messages = RequestContext.getCurrent((CdsRuntime)this.globals.getRuntime()).getMessages();
            ODataUtils.setODataErrorResponse(this.globals.getOData(), odataRequest, odataResponse, cdsResponse, null, messages, responseFormat);
        }
        catch (Exception e) {
            logger.error("An unexpected error occurred during error processing", (Throwable)e);
            String message = new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale);
            String responseContent = "{\"error\":{\"code\":\"500\",\"message\":\"" + message + "\"}}";
            odataResponse.setContent(IOUtils.toInputStream((String)responseContent, (Charset)StandardCharsets.UTF_8));
            odataResponse.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            odataResponse.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
            odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(odataRequest));
        }
    }

    private static void logBatchRequest(BatchRequestPart requestPart, ODataResponsePart responsePart) {
        if (accessLogger.isInfoEnabled()) {
            List requests = requestPart.getRequests();
            List responses = responsePart.getResponses();
            for (int i = 0; i < requests.size(); ++i) {
                StringBuilder builder = new StringBuilder();
                ODataRequest request = (ODataRequest)requests.get(i);
                builder.append("$batch ");
                builder.append(request.getMethod()).append(" ");
                builder.append(request.getRawRequestUri().substring(request.getRawBaseUri().length()));
                ODataResponse response = responses.size() > i ? (ODataResponse)responses.get(i) : (ODataResponse)responses.get(0);
                builder.append(" ").append(response.getStatusCode());
                accessLogger.info(builder.toString());
            }
        }
    }
}

