/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors.response;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.utils.CdsErrorStatuses;

public class CdsODataResponse {
    private final int statusCode;
    private final Result result;
    private final NextLinkInfo nextLinkInfo;
    private final String contentType;
    private final String contentDispositionFilename;
    private String errorCode;
    private String errorMessage;
    private MessageTarget errorTarget;

    public CdsODataResponse(int statusCode, Result result, NextLinkInfo nextLinkInfo, String contentType, String contentDispositionFilename) {
        this.statusCode = statusCode;
        this.result = result;
        this.nextLinkInfo = nextLinkInfo;
        this.contentType = contentType;
        this.contentDispositionFilename = contentDispositionFilename;
    }

    public CdsODataResponse(int statusCode, Result result, NextLinkInfo nextLinkInfo) {
        this(statusCode, result, nextLinkInfo, null, null);
    }

    public CdsODataResponse(int statusCode, Result result) {
        this(statusCode, result, null);
    }

    public CdsODataResponse(int statusCode) {
        this(statusCode, null, null);
    }

    public CdsODataResponse(ErrorStatus errorStatus, MessageTarget errorTarget, String errorMessage, boolean stackMessagesEnabled) {
        this(errorStatus.getHttpStatus(), null, null);
        this.errorCode = errorStatus instanceof CdsErrorStatuses && !stackMessagesEnabled ? String.valueOf(errorStatus.getHttpStatus()) : errorStatus.getCodeString();
        this.errorMessage = errorMessage;
        this.errorTarget = errorTarget;
    }

    public boolean isSuccess() {
        return this.statusCode < 400;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Result getResult() {
        return this.result;
    }

    public NextLinkInfo getNextLinkInfo() {
        return this.nextLinkInfo;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MessageTarget getErrorTarget() {
        return this.errorTarget;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentDispositionFilename() {
        return this.contentDispositionFilename;
    }
}

