/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors.response;

import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.TypeConverterUtils;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ETagUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetProcessor {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    static final Logger logger = LoggerFactory.getLogger(ResultSetProcessor.class);
    private final CdsRequestGlobals globals;

    public ResultSetProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
    }

    public Entity toEntity(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        if (!result.first().isPresent()) {
            return null;
        }
        EdmEntityType type = this.checkEntityType(request.getResponseType());
        EdmBindingTarget bindingTarget = EdmUtils.getEdmBindingTarget(type, this.globals.getServiceMetadata());
        return this.toEntity(bindingTarget, type, (Map<?, ?>)result.single(), expand);
    }

    public EntityCollection toEntityCollection(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        EdmEntityType type = this.checkEntityType(request.getResponseType());
        EdmBindingTarget bindingTarget = EdmUtils.getEdmBindingTarget(type, this.globals.getServiceMetadata());
        EntityCollection entitySet = new EntityCollection();
        entitySet.getEntities().addAll(this.toEntityList(bindingTarget, type, result.list(), expand));
        return entitySet;
    }

    private List<Entity> toEntityList(EdmBindingTarget bindingTarget, EdmEntityType type, List<?> result, ExpandTreeBuilder expand) {
        return result.stream().map(row -> this.toEntity(bindingTarget, type, (Map)row, expand)).collect(Collectors.toList());
    }

    private Entity toEntity(EdmBindingTarget bindingTarget, EdmEntityType type, Map<?, ?> entityRow, ExpandTreeBuilder expand) {
        Entity entity = new Entity();
        entity.setType(type.getFullQualifiedName().getFullQualifiedNameAsString());
        CdsElement eTagElement = ETagHelper.getETagElement(entity.getType(), this.globals);
        String etagElementName = eTagElement != null ? eTagElement.getName() : null;
        HashMap row = new HashMap(entityRow);
        if (bindingTarget != null) {
            try {
                entity.setId(new URI(bindingTarget.getName() + this.getEntityId(type, row)));
            }
            catch (URISyntaxException e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
            }
        }
        List propertyNames = type.getPropertyNames();
        for (String propertyName : propertyNames) {
            if (!row.containsKey(propertyName)) continue;
            Object value2 = row.remove(propertyName);
            EdmProperty edmProperty = (EdmProperty)type.getProperty(propertyName);
            Property property = this.consumeProperty(edmProperty, value2, expand);
            if (!property.getType().equals("Edm.Stream")) {
                entity.addProperty(property);
            }
            if (!Objects.equals(propertyName, etagElementName) || property.getValue() == null) continue;
            String etag = ETagUtils.createETagHeaderValue((String)property.getValue().toString());
            entity.setETag(etag);
        }
        List navigationPropertyNames = type.getNavigationPropertyNames();
        for (String navigationPropertyName : navigationPropertyNames) {
            Link link;
            Object navigationValue = row.remove(navigationPropertyName);
            if (navigationValue != null) {
                EdmNavigationProperty navigationProperty = type.getNavigationProperty(navigationPropertyName);
                link = this.createLink(navigationProperty, navigationValue, expand);
            } else {
                link = new Link();
                link.setTitle(navigationPropertyName);
            }
            if (entity.getId() != null) {
                link.setHref(entity.getId().toASCIIString() + "/" + navigationPropertyName);
            }
            entity.getNavigationLinks().add(link);
        }
        row.forEach((key, value) -> {
            Property property = new Property();
            property.setName(key.toString());
            property.setValue(ValueType.PRIMITIVE, ResultSetProcessor.fixInstantForOlingo(value));
            entity.getProperties().add(property);
        });
        return entity;
    }

    private static Object fixInstantForOlingo(Object value) {
        if (value instanceof Instant) {
            return ((Instant)value).atZone(UTC_ZONE_ID);
        }
        return value;
    }

    private String getEntityId(EdmEntityType type, Map<?, ?> row) {
        StringBuilder result = new StringBuilder();
        List keyNames = type.getKeyPredicateNames();
        boolean first = true;
        for (String keyName : keyNames) {
            EdmKeyPropertyRef keyRef = type.getKeyPropertyRef(keyName);
            if (first) {
                result.append('(');
                first = false;
            } else {
                result.append(',');
            }
            if (keyNames.size() > 1) {
                result.append(Encoder.encode((String)keyName)).append('=');
            }
            String keyValue = Encoder.encode((String)String.valueOf(row.get(keyName)));
            if (keyRef.getProperty().getType().toString().equals("Edm.String")) {
                result.append("'").append(keyValue).append("'");
                continue;
            }
            result.append(keyValue);
        }
        if (result.length() > 0) {
            result.append(')');
        }
        return result.toString();
    }

    private Property consumeProperty(EdmProperty edmProperty, Object propertyValue, ExpandTreeBuilder expand) {
        return this.consumeProperty(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), propertyValue, expand);
    }

    private Property consumeProperty(String propertyName, EdmType propertyType, boolean isCollection, Object propertyValue, ExpandTreeBuilder expand) {
        ValueType valueType;
        List convertedValue;
        Property property = new Property();
        property.setName(propertyName);
        property.setType(propertyType.getFullQualifiedName().getFullQualifiedNameAsString());
        switch (propertyType.getKind()) {
            case PRIMITIVE: 
            case DEFINITION: 
            case ENUM: {
                if (isCollection) {
                    Stream<Object> stream = propertyValue instanceof List ? ((List)propertyValue).stream() : Stream.of(propertyValue);
                    convertedValue = stream.map(v -> TypeConverterUtils.getValueBasedOnTypeOfResultSet(propertyType, v)).collect(Collectors.toList());
                    valueType = propertyType.getKind() == EdmTypeKind.ENUM ? ValueType.COLLECTION_ENUM : ValueType.COLLECTION_PRIMITIVE;
                    break;
                }
                convertedValue = TypeConverterUtils.getValueBasedOnTypeOfResultSet(propertyType, propertyValue);
                valueType = propertyType.getKind() == EdmTypeKind.ENUM ? ValueType.ENUM : ValueType.PRIMITIVE;
                break;
            }
            case COMPLEX: {
                if (isCollection) {
                    Stream<Object> stream = propertyValue instanceof List ? ((List)propertyValue).stream() : Stream.of(propertyValue);
                    convertedValue = stream.map(v -> this.consumeComplexValue((EdmComplexType)propertyType, v, expand)).collect(Collectors.toList());
                    valueType = ValueType.COLLECTION_COMPLEX;
                    break;
                }
                convertedValue = this.consumeComplexValue((EdmComplexType)propertyType, propertyValue, expand);
                valueType = ValueType.COMPLEX;
                break;
            }
            default: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{propertyType.getKind()});
            }
        }
        property.setValue(valueType, convertedValue);
        return property;
    }

    private Link createLink(EdmNavigationProperty navigationProperty, Object navigationValue, ExpandTreeBuilder expand) {
        Link link = new Link();
        link.setTitle(navigationProperty.getName());
        ExpandTreeBuilder childExpand = expand != null ? expand.expand(navigationProperty) : null;
        EdmEntityType edmEntityType = navigationProperty.getType();
        EdmBindingTarget bindingTarget = EdmUtils.getEdmBindingTarget(edmEntityType, this.globals.getServiceMetadata());
        if (navigationProperty.isCollection()) {
            List<Object> navigationValueList = navigationValue instanceof List ? (List<Object>)navigationValue : Arrays.asList(navigationValue);
            EntityCollection inlineEntitySet = new EntityCollection();
            inlineEntitySet.getEntities().addAll(this.toEntityList(bindingTarget, edmEntityType, navigationValueList, childExpand));
            link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
            link.setInlineEntitySet(inlineEntitySet);
        } else {
            Entity inlineEntity = this.toEntity(bindingTarget, edmEntityType, (Map)navigationValue, childExpand);
            link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
            link.setInlineEntity(inlineEntity);
        }
        return link;
    }

    private ComplexValue consumeComplexValue(EdmComplexType type, Object value, ExpandTreeBuilder expand) {
        ComplexValue complexValue = new ComplexValue();
        complexValue.setTypeName(type.getFullQualifiedName().getFullQualifiedNameAsString());
        Map valueMap = (Map)value;
        for (String propertyName : type.getPropertyNames()) {
            Object propertyValue = valueMap.get(propertyName);
            if (propertyValue == null) continue;
            EdmProperty edmProperty = (EdmProperty)type.getProperty(propertyName);
            Property property = this.consumeProperty(edmProperty, propertyValue, expand);
            complexValue.getValue().add(property);
        }
        for (String navigationPropertyName : type.getNavigationPropertyNames()) {
            Object navigationValue = valueMap.get(navigationPropertyName);
            if (navigationValue == null) continue;
            EdmNavigationProperty navigationProperty = type.getNavigationProperty(navigationPropertyName);
            Link link = this.createLink(navigationProperty, navigationValue, expand);
            complexValue.getNavigationLinks().add(link);
        }
        return complexValue;
    }

    private EdmEntityType checkEntityType(EdmType type) {
        if (type.getKind() != EdmTypeKind.ENTITY) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{type.getKind()});
        }
        return (EdmEntityType)type;
    }

    public Property toComplex(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        EdmComplexType type = this.checkComplexType(request.getResponseType());
        String name = this.retrieveComplexName((UriResource)request.getLastTypedResource());
        return this.consumeProperty(name, (EdmType)type, false, result.single(), expand);
    }

    public Property toComplexCollection(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        List results;
        EdmComplexType type = this.checkComplexType(request.getResponseType());
        UriResourcePartTyped resource = request.getLastTypedResource();
        String name = this.retrieveComplexName((UriResource)resource);
        if (resource.getKind().equals((Object)UriResourceKind.complexProperty)) {
            Row row = result.single();
            results = (List)row.get((Object)name);
        } else {
            results = result.list();
        }
        return this.consumeProperty(name, (EdmType)type, true, results, expand);
    }

    private EdmComplexType checkComplexType(EdmType type) {
        if (type.getKind() != EdmTypeKind.COMPLEX) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{type.getKind()});
        }
        return (EdmComplexType)type;
    }

    private String retrieveComplexName(UriResource resource) {
        String name;
        switch (resource.getKind()) {
            case complexProperty: {
                name = ((UriResourceComplexProperty)resource).getProperty().getName();
                break;
            }
            case action: {
                name = ((UriResourceAction)resource).getAction().getName();
                break;
            }
            case function: {
                name = ((UriResourceFunction)resource).getFunction().getName();
                break;
            }
            default: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
            }
        }
        return name;
    }

    public Property toPrimitive(CdsODataRequest request, Result result) {
        EdmPrimitiveType type = this.checkPrimitiveType(request.getResponseType());
        String name = this.retrievePrimitiveName((UriResource)request.getLastTypedResource());
        Object primitive = result.single().get((Object)name);
        return this.consumeProperty(name, (EdmType)type, false, primitive, null);
    }

    public Property toPrimitiveCollection(CdsODataRequest request, Result result) {
        EdmPrimitiveType type = this.checkPrimitiveType(request.getResponseType());
        String name = this.retrievePrimitiveName((UriResource)request.getLastTypedResource());
        Object primitive = result.single().get((Object)name);
        return this.consumeProperty(name, (EdmType)type, true, primitive, null);
    }

    private EdmPrimitiveType checkPrimitiveType(EdmType type) {
        if (type.getKind() != EdmTypeKind.PRIMITIVE) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{type.getKind()});
        }
        return (EdmPrimitiveType)type;
    }

    private String retrievePrimitiveName(UriResource resource) {
        String name;
        switch (resource.getKind()) {
            case primitiveProperty: {
                name = ((UriResourcePrimitiveProperty)resource).getProperty().getName();
                break;
            }
            case action: {
                name = ((UriResourceAction)resource).getAction().getName();
                break;
            }
            case function: {
                name = ((UriResourceFunction)resource).getFunction().getName();
                break;
            }
            default: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
            }
        }
        return name;
    }

    public static int toCount(Result result) {
        int count = 0;
        for (Map row : result.list()) {
            count += Integer.parseInt(row.get("count").toString());
        }
        return count;
    }
}

