/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.query.apply.ElementAggregator;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;

public class AggregateTransformation
implements Transformation {
    private final Aggregate agg;
    private CdsModel model;

    public AggregateTransformation(Aggregate agg) {
        this.agg = agg;
        this.model = CdsRequestGlobals.currentContext().getModel();
    }

    @Override
    public Select<?> apply(Select<?> select) {
        ElementAggregator aggregator = new ElementAggregator(CqnStatementUtils.rowType((CdsModel)this.model, select));
        ArrayList<Object> items = new ArrayList<Object>();
        List agExps = this.agg.getExpressions();
        for (AggregateExpression agExp : agExps) {
            String alias;
            Value<?> func;
            if (agExp.getInlineAggregateExpression() != null) {
                List uriResources = agExp.getPath();
                if (uriResources.size() > 2) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, uriResources.toArray());
                }
                StructuredType type = CQL.to((String)((UriResource)uriResources.get(0)).getSegmentValue());
                AggregateExpression inlineAgExp = agExp.getInlineAggregateExpression();
                Value<?> func2 = aggregator.genericAggregate(inlineAgExp.getExpression(), inlineAgExp.getStandardMethod());
                items.add(type.expand(Arrays.asList(func2.as(inlineAgExp.getAlias()))));
                continue;
            }
            if (agExp.getExpression() != null) {
                func = aggregator.genericAggregate(agExp.getExpression(), agExp.getStandardMethod());
                alias = agExp.getAlias();
            } else {
                String path = agExp.getPath().stream().map(p -> p.getSegmentValue()).collect(Collectors.joining("."));
                func = aggregator.customAggregate(path);
                alias = path.startsWith("$") ? agExp.getAlias() : path;
            }
            items.add(func.as(alias));
        }
        select.items().stream().filter(i -> i.isSelectList()).forEach(items::add);
        select.columns(items);
        return select;
    }

    @Override
    public int rank() {
        return 2;
    }
}

