/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;

public class FilterByAggregateTransformation
implements Transformation {
    private static final RefSegment OUTER = CQL.refSegment((String)"$outer");
    private final CdsModel model = CdsRequestGlobals.currentContext().getModel();
    private final List<GroupByItem> gByItems;
    private final Expression filter;

    public FilterByAggregateTransformation(List<GroupByItem> gByItems, Expression filter) {
        this.gByItems = gByItems;
        this.filter = filter;
    }

    @Override
    public Select<?> apply(Select<?> select) {
        Select inner = Select.copy(select);
        CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)inner);
        ArrayList<CqnSelectListValue> dimensions = new ArrayList<CqnSelectListValue>(this.gByItems.size());
        ArrayList<Predicate> innerToOuter = new ArrayList<Predicate>(this.gByItems.size());
        for (GroupByItem gByItem : this.gByItems) {
            List path = gByItem.getPath();
            ElementRef<?> ref = FilterByAggregateTransformation.ref(path);
            innerToOuter.add(this.eq(ref, FilterByAggregateTransformation.outer(ref)));
            dimensions.add(ref.as(this.structuredAlias(ref)));
        }
        inner.groupBy(dimensions);
        inner.columns(dimensions);
        inner.where((CqnPredicate)innerToOuter.stream().collect(Conjunction.and()));
        inner.having((CqnPredicate)ExpressionParser.parseFilter(rowType, this.filter));
        select.where(e -> e.exists(o -> inner));
        return select;
    }

    private Predicate eq(ElementRef<?> ref, ElementRef<?> outer) {
        return CQL.comparison(ref, (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.EQ, outer);
    }

    @Override
    public int rank() {
        return 2;
    }

    private String structuredAlias(ElementRef<?> ref) {
        return ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
    }

    private static ElementRef<?> ref(List<UriResource> uriResources) {
        ArrayList<RefSegment> segments = new ArrayList<RefSegment>(uriResources.size());
        for (UriResource resource : uriResources) {
            segments.add(CQL.refSegment((String)resource.getSegmentValue()));
        }
        return CQL.get(segments);
    }

    private static ElementRef<?> outer(ElementRef<?> ref) {
        List refSegments = ref.segments();
        ArrayList<RefSegment> segments = new ArrayList<RefSegment>(refSegments.size() + 1);
        segments.add(OUTER);
        segments.addAll(refSegments);
        return CQL.get(segments);
    }
}

