/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.google.common.collect.ImmutableSet;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;

public class FilterTransformation
implements Transformation {
    private final Filter filter;
    private final CdsModel model;
    private static final Set<String> AGGREGTAING_METHODS = ImmutableSet.of((Object)"SUM", (Object)"MIN", (Object)"MAX", (Object)"AVERAGE", (Object)"COUNT");

    public FilterTransformation(Filter filter) {
        this.filter = filter;
        this.model = CdsRequestGlobals.currentContext().getModel();
    }

    @Override
    public Select<?> apply(Select<?> select) {
        FilterOption filterOption = this.filter.getFilterOption();
        CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)this.model, select);
        Predicate predicate = ExpressionParser.parseFilter(rowType, filterOption.getExpression());
        if (FilterTransformation.computesAggregate(predicate)) {
            select.having((CqnPredicate)predicate);
        } else {
            Optional where = select.where();
            if (where.isPresent()) {
                predicate = predicate.and((CqnPredicate)where.get(), new CqnPredicate[0]);
            }
            select.where((CqnPredicate)predicate);
        }
        return select;
    }

    private static boolean computesAggregate(Predicate predicate) {
        final AtomicBoolean computesAggregate = new AtomicBoolean(false);
        predicate.accept(new CqnVisitor(){

            public void visit(CqnFunc func) {
                String methodName = func.func().toUpperCase(Locale.US);
                if (AGGREGTAING_METHODS.contains(methodName)) {
                    computesAggregate.set(true);
                }
            }
        });
        return computesAggregate.get();
    }

    @Override
    public int rank() {
        return 1;
    }

    @Override
    public boolean requiresWrapping(Transformation previous) {
        return this.rank() < previous.rank();
    }
}

