/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.apply.ApplyHandler;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;

public class GroupByTransformation
implements Transformation {
    private final GroupBy gBy;

    public GroupByTransformation(GroupBy gBy) {
        this.gBy = gBy;
    }

    @Override
    public Select<?> apply(Select<?> select) {
        List gByItems = this.gBy.getGroupByItems();
        ArrayList<CqnSelectListValue> dimensions = new ArrayList<CqnSelectListValue>(gByItems.size());
        for (GroupByItem gByItem : gByItems) {
            ElementRef<?> ref = GroupByTransformation.ref(gByItem.getPath());
            dimensions.add(ref.as(this.structuredAlias(ref)));
        }
        select.groupBy(dimensions);
        ArrayList selectItems = new ArrayList();
        if (this.gBy.getApplyOption() != null) {
            ApplyOption gByApplyOption = this.gBy.getApplyOption();
            ApplyHandler applyHandler = new ApplyHandler(gByApplyOption);
            List<Transformation> transformations = applyHandler.getTransformations();
            for (Transformation transformation : transformations) {
                select = (Select)transformation.apply(select);
            }
            selectItems.addAll(select.items());
        }
        dimensions.stream().forEach(selectItems::add);
        select.columns(selectItems);
        return select;
    }

    private String structuredAlias(ElementRef<?> ref) {
        return ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
    }

    private static ElementRef<?> ref(List<UriResource> uriResources) {
        ArrayList<RefSegment> segments = new ArrayList<RefSegment>(uriResources.size());
        for (UriResource resource : uriResources) {
            segments.add(CQL.refSegment((String)resource.getSegmentValue()));
        }
        return CQL.get(segments);
    }

    @Override
    public int rank() {
        return 2;
    }
}

