/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnSelect;

public class LimitCalculator {
    private long skip;
    private long top;

    private LimitCalculator(long skip, long top) {
        this.skip = skip;
        this.top = top;
    }

    public static LimitCalculator of(CqnLimit limit) {
        return new LimitCalculator(limit.skip(), limit.top());
    }

    public static LimitCalculator of(CqnSelect select) {
        return select.limit().map(LimitCalculator::of).orElse(LimitCalculator.initial());
    }

    public static LimitCalculator initial() {
        return new LimitCalculator(0L, Integer.MAX_VALUE);
    }

    public LimitCalculator top(long rows) {
        if (rows < this.top) {
            this.top = rows;
        }
        return this;
    }

    public LimitCalculator skip(long rows) {
        this.skip += rows;
        this.top -= rows;
        return this;
    }

    public long top() {
        return this.top;
    }

    public long skip() {
        return this.skip;
    }
}

