/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;

public class EdmUtils {
    private static final String PARAMETERS = "Parameters";
    private static final String TYPE = "Type";
    private static final String SET = "Set";

    public static EdmBindingTarget getEdmBindingTarget(EdmEntityType entityType, ServiceMetadata serviceMetadata) {
        EdmEntityContainer container = serviceMetadata.getEdm().getEntityContainer();
        ArrayList bindingTargets = new ArrayList();
        bindingTargets.addAll(container.getEntitySets());
        bindingTargets.addAll(container.getSingletons());
        for (EdmBindingTarget bindingTarget : bindingTargets) {
            EdmEntityType bindingTargetEntityType = bindingTarget.getEntityType();
            if (!bindingTargetEntityType.getFullQualifiedName().getFullQualifiedNameAsString().equalsIgnoreCase(entityType.getFullQualifiedName().getFullQualifiedNameAsString())) continue;
            return bindingTarget;
        }
        return null;
    }

    public static boolean isParametersEntityType(EdmEntityType entityType) {
        String setName;
        EdmNavigationProperty setNavigation;
        String name = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        return name.endsWith(PARAMETERS) && (setNavigation = entityType.getNavigationProperty(SET)) != null && (setName = setNavigation.getType().getFullQualifiedName().getFullQualifiedNameAsString()).endsWith(TYPE) && name.startsWith(setName.substring(0, setName.length() - TYPE.length()));
    }

    public static boolean isSetEntityType(EdmEntityType entityType) {
        String paramName;
        EdmNavigationProperty paramNavigation;
        String name = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        return name.endsWith(TYPE) && (paramNavigation = entityType.getNavigationProperty(PARAMETERS)) != null && (paramName = paramNavigation.getType().getFullQualifiedName().getFullQualifiedNameAsString()).endsWith(PARAMETERS) && name.startsWith(paramName.substring(0, paramName.length() - PARAMETERS.length()));
    }

    public static String getCdsEntityName(EdmEntityType entityType, Map<String, String> cdsNamesMap) {
        String name = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        if (EdmUtils.isSetEntityType(entityType)) {
            name = name.substring(0, name.length() - TYPE.length());
        } else if (EdmUtils.isParametersEntityType(entityType)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PARAMETERIZED_VIEW, new Object[0]);
        }
        String cdsName = cdsNamesMap.get(name);
        if (cdsName != null) {
            name = cdsName;
        }
        return name;
    }

    public static Optional<EdmProperty> getEdmProperty(UriResourcePartTyped resource) {
        if (resource instanceof UriResourcePrimitiveProperty) {
            return Optional.of(((UriResourcePrimitiveProperty)resource).getProperty());
        }
        if (resource instanceof UriResourceComplexProperty) {
            return Optional.of(((UriResourceComplexProperty)resource).getProperty());
        }
        return Optional.empty();
    }

    public static boolean isEdmStream(Optional<EdmProperty> edmProperty) {
        if (edmProperty.isPresent()) {
            return edmProperty.get().getType() instanceof EdmStream;
        }
        return false;
    }
}

