/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.PayloadProcessor;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.adapter.odata.v4.utils.TypeConverterUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerResult;
import org.apache.olingo.server.api.deserializer.FixedFormatDeserializer;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;

public class RequestBodyExtractor {
    private final CdsRequestGlobals globals;
    private final ODataRequest odataRequest;
    private final ContentType requestFormat;
    private final PayloadProcessor payloadProcessor;

    public RequestBodyExtractor(CdsRequestGlobals globals, ODataRequest odataRequest, ContentType requestFormat) {
        this.globals = globals;
        this.odataRequest = odataRequest;
        this.requestFormat = requestFormat;
        this.payloadProcessor = new PayloadProcessor(globals);
    }

    public Map<String, Object> extractBodyFromProperty(Optional<EdmProperty> edmProperty, UriResourcePartTyped resource) {
        if (edmProperty.isPresent()) {
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            String name = edmProperty.get().getName();
            if (resource.isCollection()) {
                bodyMap.put(name, new ArrayList());
            } else {
                bodyMap.put(name, null);
            }
            return bodyMap;
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
    }

    public Map<String, Object> extractBodyFromFunctionParameters(UriResourcePartTyped resource) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        EdmFunction function = ((UriResourceFunction)resource).getFunction();
        for (UriParameter parameter : ((UriResourceFunction)resource).getParameters()) {
            EdmParameter edmParameter = function.getParameter(parameter.getName());
            bodyMap.put(parameter.getName(), TypeConverterUtils.convertToType(edmParameter.getType(), parameter.getText()));
        }
        return bodyMap;
    }

    public Map<String, Object> extractBodyFromPrimitiveValue(Optional<EdmProperty> edmProperty, UriResourcePartTyped resource) {
        if (edmProperty.isPresent()) {
            try {
                FixedFormatDeserializer deserializer = this.globals.getOData().createFixedFormatDeserializer();
                Object value = deserializer.primitiveValue(this.odataRequest.getBody(), edmProperty.get());
                HashMap<String, Object> bodyMap = new HashMap<String, Object>();
                bodyMap.put(edmProperty.get().getName(), value);
                return bodyMap;
            }
            catch (DeserializerException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{e.getLocalizedMessage(), e});
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
    }

    public Map<String, Object> extractBodyFromJson(Optional<EdmProperty> edmProperty, UriResourcePartTyped resource, EdmType responseType) {
        ODataDeserializer deserializer;
        try {
            deserializer = this.globals.getOData().createDeserializer(this.requestFormat, this.globals.getServiceMetadata(), Arrays.asList(ODataUtils.getODataVersion(this.odataRequest)));
        }
        catch (DeserializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DESERIALIZER_FAILED, new Object[]{e});
        }
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        switch (resource.getKind()) {
            case singleton: 
            case entitySet: 
            case navigationProperty: {
                try {
                    DeserializerResult result = deserializer.entity(this.odataRequest.getBody(), (EdmEntityType)responseType);
                    bodyMap.putAll(this.payloadProcessor.getEntity(result.getEntity()));
                    break;
                }
                catch (DeserializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{e.getLocalizedMessage(), e});
                }
            }
            case action: {
                try {
                    DeserializerResult result = deserializer.actionParameters(this.odataRequest.getBody(), ((UriResourceAction)resource).getAction());
                    result.getActionParameters().forEach((name, value) -> bodyMap.put((String)name, this.payloadProcessor.getValue((Valuable)value)));
                    break;
                }
                catch (DeserializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{e.getLocalizedMessage(), e});
                }
            }
            case primitiveProperty: 
            case complexProperty: {
                try {
                    if (!edmProperty.isPresent()) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
                    }
                    EdmProperty edmProp = edmProperty.get();
                    Property property = deserializer.property(this.odataRequest.getBody(), edmProp).getProperty();
                    bodyMap.put(property.getName(), this.payloadProcessor.getValue((Valuable)property));
                    break;
                }
                catch (DeserializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{e.getLocalizedMessage(), e});
                }
            }
            default: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
            }
        }
        return bodyMap;
    }

    public Map<String, Object> extractBodyFromBinaryValue(Optional<EdmProperty> edmProperty, UriResourcePartTyped resource) {
        if (edmProperty.isPresent()) {
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            bodyMap.put(edmProperty.get().getName(), this.odataRequest.getBody());
            return bodyMap;
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
    }
}

