/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.CdsProcessor;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.processors.response.ResultSetProcessor;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v4.utils.ChangeSetContextAwareInputStream;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.MessagesUtils;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.prefer.PreferencesApplied;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializer;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.PrimitiveValueSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilderImpl;

public class ODataProcessor {
    private final CdsRequestGlobals globals;
    private final ResultSetProcessor resultSetProcessor;
    private final CdsProcessor cdsProcessor;
    private final EdmUtils edmUtils;

    public ODataProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.resultSetProcessor = new ResultSetProcessor(globals);
        this.cdsProcessor = new CdsProcessor(globals);
        this.edmUtils = new EdmUtils(globals);
    }

    public void processSingleEntityRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            ExpandOption expand;
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            Entity entity = this.resultSetProcessor.toEntity((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expandOption = expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            if (entity != null && odataRequest.getMethod() != HttpMethod.GET && cdsRequest.getLastResource() == cdsRequest.getLastEntityResource(true)) {
                String location = odataRequest.getRawBaseUri() + odataRequest.getRawODataPath();
                UriResource lastResource = cdsRequest.getLastResource();
                if (!location.endsWith(")") && (lastResource.getKind() == UriResourceKind.entitySet || lastResource.getKind() == UriResourceKind.navigationProperty && ((UriResourceNavigation)lastResource).getProperty().isCollection())) {
                    try {
                        String keyPredicate = this.globals.getOData().createUriHelper().buildKeyPredicate((EdmEntityType)cdsRequest.getResponseType(), entity);
                        if (!StringUtils.isEmpty((String)keyPredicate)) {
                            location = location + '(' + keyPredicate + ')';
                        }
                    }
                    catch (SerializerException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                    }
                }
                odataResponse.setHeader("Location", location);
                odataResponse.setHeader("OData-EntityID", location);
            }
            SerializerResult serializerResult = null;
            if (entity != null) {
                String etag = entity.getETag();
                if (etag != null) {
                    odataResponse.setHeader("ETag", etag);
                }
                if (cdsResponse.getStatusCode() < 204 && cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                    this.checkCountOptionsOnExpand(entity, uriInfo.getExpandOption());
                    ContextURL contextUrl = this.getContextUrl((CdsODataRequest)cdsRequest, false, uriInfo.getSelectOption(), expand);
                    EntitySerializerOptions options = EntitySerializerOptions.with().contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(expand).build();
                    try {
                        serializerResult = this.createSerializer(odataRequest, responseFormat).entity(this.globals.getServiceMetadata(), (EdmEntityType)cdsRequest.getResponseType(), entity, options);
                    }
                    catch (SerializerException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                    }
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    public void processCollectionEntityRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            SerializerResult serializerResult;
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            EntityCollection entityCollection = this.resultSetProcessor.toEntityCollection((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            entityCollection.forEach(entity -> this.checkCountOptionsOnExpand((Entity)entity, uriInfo.getExpandOption()));
            NextLinkInfo nextLinkInfo = cdsResponse.getNextLinkInfo();
            if (nextLinkInfo != null && cdsResponse.getResult().rowCount() >= (long)nextLinkInfo.getPageSize()) {
                URI nextLink = this.getNextLink(odataRequest, nextLinkInfo);
                entityCollection.setNext(nextLink);
            }
            ODataProcessor.setInlineCount(uriInfo, cdsResponse.getResult(), entityCollection);
            try {
                ContextURL contextUrl = this.getContextUrl((CdsODataRequest)cdsRequest, true, uriInfo.getSelectOption(), expand);
                if (uriInfo.getApplyOption() != null) {
                    EdmAssistedSerializerOptions optionsForApply = EdmAssistedSerializerOptions.with().contextURL(contextUrl).build();
                    serializerResult = this.createSerializerForApply(responseFormat).entityCollection(this.globals.getServiceMetadata(), (EdmEntityType)cdsRequest.getResponseType(), (AbstractEntityCollection)entityCollection, optionsForApply);
                } else {
                    EntityCollectionSerializerOptions options = EntityCollectionSerializerOptions.with().contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(expand).count(uriInfo.getCountOption()).build();
                    serializerResult = this.createSerializer(odataRequest, responseFormat).entityCollection(this.globals.getServiceMetadata(), (EdmEntityType)cdsRequest.getResponseType(), (AbstractEntityCollection)entityCollection, options);
                }
            }
            catch (SerializerException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, serializerResult.getContent(), responseFormat);
        });
    }

    @VisibleForTesting
    static void setInlineCount(UriInfo uriInfo, Result result, EntityCollection entityCollection) {
        if (uriInfo.getCountOption() != null && uriInfo.getCountOption().getValue()) {
            int inlineCount = (int)result.inlineCount();
            if (inlineCount == -1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_VALUE_FOR_COUNT, new Object[0]);
            }
            entityCollection.setCount(Integer.valueOf(inlineCount));
        }
    }

    public void processSingleComplexRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            Property complexProperty = this.resultSetProcessor.toComplex((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            SerializerResult serializerResult = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, false, uriInfo.getSelectOption(), expand);
                ComplexSerializerOptions options = ComplexSerializerOptions.with().contextURL(contextURL).select(uriInfo.getSelectOption()).expand(expand).build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).complex(this.globals.getServiceMetadata(), (EdmComplexType)cdsRequest.getResponseType(), complexProperty, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    public void processCollectionComplexRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            Property complexProperty = this.resultSetProcessor.toComplexCollection((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            SerializerResult serializerResult = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, true, uriInfo.getSelectOption(), expand);
                ComplexSerializerOptions options = ComplexSerializerOptions.with().contextURL(contextURL).select(uriInfo.getSelectOption()).expand(expand).build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).complexCollection(this.globals.getServiceMetadata(), (EdmComplexType)cdsRequest.getResponseType(), complexProperty, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    public void processSinglePrimitiveRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        ChangeSetContextSPI changeSetContext;
        if (this.isGetStreamContext(odataRequest, uriInfo, requestFormat)) {
            changeSetContext = ChangeSetContextSPI.open();
            this.globals.getUnclosedChangeSetTracker().set(true);
        } else {
            changeSetContext = null;
        }
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            Object content;
            SerializerResult serializerResult = null;
            Property property = this.resultSetProcessor.toPrimitive((CdsODataRequest)cdsRequest, cdsResponse.getResult());
            boolean isStream = cdsRequest.getLastTypedResource().getType() instanceof EdmStream;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL && !isStream) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, false, null, null);
                PrimitiveSerializerOptions.Builder builder = PrimitiveSerializerOptions.with().contextURL(contextURL);
                this.getEdmProperty((CdsODataRequest)cdsRequest).ifPresent(edmProp -> builder.facetsFrom(edmProp));
                PrimitiveSerializerOptions options = builder.build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).primitive(this.globals.getServiceMetadata(), (EdmPrimitiveType)cdsRequest.getResponseType(), property, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            ContentType contentType = !StringUtils.isEmpty((String)cdsResponse.getContentType()) ? ContentType.create((String)cdsResponse.getContentType()) : responseFormat;
            if (changeSetContext != null && property.getValue() != null) {
                InputStream stream;
                if (property.getValue() instanceof Reader) {
                    Charset charset = ODataUtils.getCharset(contentType);
                    stream = new ReaderInputStream((Reader)property.getValue(), charset);
                } else {
                    stream = (InputStream)property.getValue();
                }
                content = new ChangeSetContextAwareInputStream(stream, changeSetContext, this.globals.getUnclosedChangeSetTracker());
            } else {
                content = serializerResult != null ? serializerResult.getContent() : null;
            }
            this.setContentDispositionHeaderIfNotNull(odataResponse, cdsResponse.getContentDispositionFilename());
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, (InputStream)content, contentType);
        });
    }

    public void processSinglePrimitiveValueRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            if (this.isValueRequestOnStreamProperty((CdsODataRequest)cdsRequest)) {
                UriResourcePartTyped lastTypedResource = cdsRequest.getLastTypedResource();
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_ACCESS_NOT_ALLOWED, new Object[]{lastTypedResource.getSegmentValue()});
            }
            Property property = this.resultSetProcessor.toPrimitive((CdsODataRequest)cdsRequest, cdsResponse.getResult());
            Object value = property.getValue();
            InputStream content = null;
            if (value != null && cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                PrimitiveValueSerializerOptions.Builder builder = PrimitiveValueSerializerOptions.with();
                this.getEdmProperty((CdsODataRequest)cdsRequest).ifPresent(edmProp -> builder.facetsFrom(edmProp));
                PrimitiveValueSerializerOptions options = builder.build();
                try {
                    content = this.globals.getOData().createFixedFormatSerializer().primitiveValue((EdmPrimitiveType)cdsRequest.getResponseType(), value, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    public void processCollectionPrimitiveRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            Property property = this.resultSetProcessor.toPrimitiveCollection((CdsODataRequest)cdsRequest, cdsResponse.getResult());
            SerializerResult serializerResult = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, true, null, null);
                PrimitiveSerializerOptions options = PrimitiveSerializerOptions.with().contextURL(contextURL).build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).primitiveCollection(this.globals.getServiceMetadata(), (EdmPrimitiveType)cdsRequest.getResponseType(), property, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    public void processNoContentRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            if (this.isValueRequestOnStreamProperty((CdsODataRequest)cdsRequest)) {
                UriResourcePartTyped lastTypedResource = cdsRequest.getLastTypedResource();
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_ACCESS_NOT_ALLOWED, new Object[]{lastTypedResource.getSegmentValue()});
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, null, null);
        });
    }

    public void processCountRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) {
        this.processRequest(odataRequest, odataResponse, uriInfo, null, (cdsRequest, cdsResponse) -> {
            InputStream content;
            int count = ResultSetProcessor.toCount(cdsResponse.getResult());
            try {
                content = this.globals.getOData().createFixedFormatSerializer().count(Integer.valueOf(count));
            }
            catch (SerializerException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, ContentType.TEXT_PLAIN);
        });
    }

    private boolean isValueRequestOnStreamProperty(CdsODataRequest request) {
        UriResource lastResource = request.getLastResource();
        UriResourcePartTyped lastTypedResource = request.getLastTypedResource();
        return lastResource.getKind().equals((Object)UriResourceKind.value) && lastTypedResource.getType() instanceof EdmStream;
    }

    private void processRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, BiConsumer<CdsODataRequest, CdsODataResponse> processor) {
        CdsODataRequest cdsRequest = new CdsODataRequest(odataRequest, uriInfo, requestFormat, this.globals);
        this.cdsProcessor.processRequest(cdsRequest, cdsResponse -> {
            if (cdsResponse.isSuccess()) {
                processor.accept(cdsRequest, (CdsODataResponse)cdsResponse);
            } else {
                ODataUtils.setODataErrorResponse(this.globals.getOData(), odataRequest, odataResponse, cdsResponse, ODataUtils.getBindingParameter(this.globals.getModel(), uriInfo), ContentType.APPLICATION_JSON);
            }
        });
    }

    private void setODataResponse(CdsODataRequest cdsRequest, CdsODataResponse cdsResponse, ODataResponse odataResponse, InputStream content, ContentType contentType) {
        if (content != null && contentType != null) {
            odataResponse.setStatusCode(cdsResponse.getStatusCode());
            odataResponse.setHeader("Content-Type", contentType.toContentTypeString());
            odataResponse.setContent(content);
        } else {
            odataResponse.setStatusCode(cdsResponse.getStatusCode() < 204 ? 204 : cdsResponse.getStatusCode());
        }
        Preferences.Return returnPreference = cdsRequest.getReturnPreference();
        if (returnPreference != null) {
            String applied = PreferencesApplied.with().returnRepresentation(returnPreference).build().toValueString();
            odataResponse.setHeader("Preference-Applied", applied);
        }
        odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(cdsRequest.getODataRequest()));
        String sapMessageHeader = MessagesUtils.getSapMessagesHeader(ODataUtils.getBindingParameter(this.globals.getModel(), cdsRequest.getUriInfo()), RequestContext.getCurrent((CdsRuntime)this.globals.getRuntime()).getMessages());
        if (!StringUtils.isEmpty((String)sapMessageHeader)) {
            odataResponse.setHeader("sap-messages", sapMessageHeader);
        }
    }

    private ODataSerializer createSerializer(ODataRequest odataRequest, ContentType responseFormat) {
        return ODataUtils.createSerializer(this.globals.getOData(), odataRequest, responseFormat);
    }

    private EdmAssistedSerializer createSerializerForApply(ContentType responseFormat) {
        return ODataUtils.createSerializerForApply(this.globals.getOData(), responseFormat);
    }

    private ContextURL getContextUrl(CdsODataRequest request, boolean isCollection, SelectOption select, ExpandOption expand) {
        try {
            ContextURL.Builder builder = ContextURL.with();
            UriHelper uriHelper = this.globals.getOData().createUriHelper();
            if (this.globals.getRuntime().getEnvironment().getCdsProperties().getOdataV4().isContextAbsoluteUrl()) {
                try {
                    builder.serviceRoot(new URI(request.getODataRequest().getRawBaseUri() + "/"));
                }
                catch (URISyntaxException e) {
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
                }
            }
            boolean isSingleton = false;
            UriResource lastResource = request.getLastResource();
            EdmType responseType = request.getResponseType();
            if (lastResource.getKind() == UriResourceKind.action || lastResource.getKind() == UriResourceKind.function) {
                if (isCollection) {
                    builder.asCollection();
                }
                builder.type(responseType);
            } else {
                UriResourcePartTyped entityResource = request.getLastEntityResource(false);
                EdmEntityType entityType = (EdmEntityType)entityResource.getType();
                EdmBindingTarget bindingTarget = this.edmUtils.getEdmBindingTarget(entityType);
                List uriResources = request.getUriInfo().getUriResourceParts();
                int entitySetIndex = uriResources.indexOf(entityResource);
                if (entitySetIndex + 1 < uriResources.size()) {
                    String keys = "";
                    if (entityResource.getKind() == UriResourceKind.entitySet) {
                        keys = "(" + uriHelper.buildContextURLKeyPredicate(((UriResourceEntitySet)entityResource).getKeyPredicates()) + ")";
                    } else if (entityResource.getKind() == UriResourceKind.navigationProperty) {
                        keys = "(" + uriHelper.buildContextURLKeyPredicate(((UriResourceNavigation)entityResource).getKeyPredicates()) + ")";
                    }
                    builder.entitySetOrSingletonOrType(bindingTarget.getName() + keys);
                    StringBuilder navigationPathBuilder = new StringBuilder();
                    UriResourceNavigation previousUriResourceNavigation = null;
                    for (UriResource uriResource : uriResources.subList(entitySetIndex + 1, uriResources.size())) {
                        String navKeys;
                        if (previousUriResourceNavigation != null && !previousUriResourceNavigation.isCollection() && (navKeys = uriHelper.buildContextURLKeyPredicate(previousUriResourceNavigation.getKeyPredicates())) != null) {
                            navigationPathBuilder.append("(").append(navKeys).append(")");
                        }
                        if (navigationPathBuilder.length() > 0) {
                            navigationPathBuilder.append("/");
                        }
                        if (uriResource.getKind() == UriResourceKind.navigationProperty) {
                            UriResourceNavigation uriResourceNavigation = (UriResourceNavigation)uriResource;
                            navigationPathBuilder.append(uriResourceNavigation.getProperty().getName());
                            previousUriResourceNavigation = uriResourceNavigation;
                            continue;
                        }
                        if (uriResource.getKind() == UriResourceKind.complexProperty) {
                            navigationPathBuilder.append(((UriResourceComplexProperty)uriResource).getProperty().getName());
                            continue;
                        }
                        if (uriResource.getKind() == UriResourceKind.primitiveProperty) {
                            navigationPathBuilder.append(((UriResourcePrimitiveProperty)uriResource).getProperty().getName());
                            continue;
                        }
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{uriResource.getKind()});
                    }
                    builder.navOrPropertyPath(navigationPathBuilder.toString());
                } else if (responseType.getKind() == EdmTypeKind.ENTITY) {
                    isSingleton = bindingTarget instanceof EdmSingleton;
                    builder.entitySetOrSingletonOrType(bindingTarget.getName());
                } else {
                    if (isCollection) {
                        builder.asCollection();
                    }
                    builder.type(responseType);
                }
                if (responseType.getKind() == EdmTypeKind.ENTITY && !isCollection && !isSingleton) {
                    builder.suffix(ContextURL.Suffix.ENTITY);
                }
            }
            if ((expand != null || select != null) && responseType instanceof EdmStructuredType) {
                String selectList = uriHelper.buildContextURLSelectList((EdmStructuredType)responseType, expand, select);
                builder.selectList(selectList);
            }
            return builder.build();
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
        }
    }

    private URI getNextLink(ODataRequest odataRequest, NextLinkInfo nextLinkInfo) {
        String skiptoken = SystemQueryOptionKind.SKIPTOKEN.toString();
        String odataPath = odataRequest.getRawODataPath().substring(1);
        String query = StringUtils.isEmpty((String)odataRequest.getRawQueryPath()) ? "" : odataRequest.getRawQueryPath();
        String filteredQuery = Stream.of(query.split("&")).filter(q -> !q.startsWith(skiptoken)).collect(Collectors.joining("&"));
        String skiptokenQuery = skiptoken + "=" + nextLinkInfo.getNextSkipToken();
        String fullQuery = StringUtils.isEmpty((String)filteredQuery) ? skiptokenQuery : filteredQuery + "&" + skiptokenQuery;
        URI nextLink = URI.create(odataPath + "?" + fullQuery);
        return nextLink;
    }

    private void checkCountOptionsOnExpand(Entity entity, ExpandOption expandOption) {
        if (expandOption != null) {
            expandOption.getExpandItems().forEach(expandItem -> {
                if (expandItem.getCountOption() != null && expandItem.getCountOption().getValue()) {
                    EntityCollection inlineEntityCollection;
                    String expandedItemName = !expandItem.getResourcePath().getUriResourceParts().isEmpty() ? ((UriResource)expandItem.getResourcePath().getUriResourceParts().get(0)).getSegmentValue() : "";
                    EntityCollection entityCollection = inlineEntityCollection = entity.getNavigationLink(expandedItemName) != null ? entity.getNavigationLink(expandedItemName).getInlineEntitySet() : null;
                    if (inlineEntityCollection != null) {
                        inlineEntityCollection.setCount(Integer.valueOf(inlineEntityCollection.getEntities().size()));
                        if (expandItem.getExpandOption() != null) {
                            inlineEntityCollection.getEntities().forEach(inlineEntity -> this.checkCountOptionsOnExpand((Entity)inlineEntity, expandItem.getExpandOption()));
                        }
                    }
                }
            });
        }
    }

    private Optional<EdmProperty> getEdmProperty(CdsODataRequest cdsRequest) {
        Optional<EdmProperty> prop = Optional.ofNullable(cdsRequest.getLastTypedResource()).filter(UriResourcePrimitiveProperty.class::isInstance).map(UriResourcePrimitiveProperty.class::cast).map(p -> p.getProperty());
        return prop;
    }

    private boolean isGetStreamContext(ODataRequest odataRequest, UriInfo uriInfo, ContentType requestFormat) {
        HttpMethod method = odataRequest.getMethod();
        CdsODataRequest cdsODataRequest = new CdsODataRequest(odataRequest, uriInfo, requestFormat, this.globals);
        return method.equals((Object)HttpMethod.GET) && cdsODataRequest.getLastTypedResource().getType() instanceof EdmStream;
    }

    private void setContentDispositionHeaderIfNotNull(ODataResponse response, String filename) {
        if (!StringUtils.isEmpty((String)filename)) {
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", filename));
        }
    }
}

