/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors.request;

import com.google.common.collect.Streams;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.RequestBodyExtractor;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.CorrelationIdUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.TemporalRangeUtils;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;

public class CdsODataRequest
implements ParameterInfo {
    private final CdsRequestGlobals globals;
    private final EdmxFlavourMapper edmxFlavourMapper;
    private final EdmUtils edmUtils;
    private final ODataRequest odataRequest;
    private final UriInfo uriInfo;
    private final ContentType requestFormat;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private Map<String, Object> bodyMap;
    private String correlationId;
    private Locale locale;
    private Instant validFrom;
    private Instant validTo;

    public CdsODataRequest(ODataRequest odataRequest, UriInfo uriInfo, ContentType requestFormat, CdsRequestGlobals globals) {
        this.odataRequest = odataRequest;
        this.uriInfo = uriInfo;
        this.requestFormat = requestFormat;
        this.globals = globals;
        this.edmxFlavourMapper = EdmxFlavourMapper.create(globals.getEdmxFlavour(), true);
        this.edmUtils = new EdmUtils(globals);
        Streams.concat((Stream[])new Stream[]{uriInfo.getSystemQueryOptions().stream(), uriInfo.getCustomQueryOptions().stream()}).forEach(query -> this.queryParameters.put(query.getName(), query.getText()));
    }

    public ODataRequest getODataRequest() {
        return this.odataRequest;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public UriResource getLastResource() {
        List resources = this.uriInfo.getUriResourceParts();
        return (UriResource)resources.get(resources.size() - 1);
    }

    public UriResourcePartTyped getLastTypedResource() {
        List resources = this.uriInfo.getUriResourceParts();
        for (int i = resources.size() - 1; i >= 0; --i) {
            UriResource resource = (UriResource)resources.get(i);
            if (!(resource instanceof UriResourcePartTyped)) continue;
            return (UriResourcePartTyped)resource;
        }
        return null;
    }

    public UriResourcePartTyped getLastEntityResource(boolean includeContainment) {
        UriResource lastEntityResource = null;
        for (UriResource resource : this.uriInfo.getUriResourceParts()) {
            if (resource.getKind() == UriResourceKind.entitySet || resource.getKind() == UriResourceKind.singleton) {
                lastEntityResource = resource;
                continue;
            }
            if (resource.getKind() != UriResourceKind.navigationProperty) break;
            if (!includeContainment && ((UriResourceNavigation)resource).getProperty().containsTarget()) continue;
            lastEntityResource = resource;
        }
        return (UriResourcePartTyped)lastEntityResource;
    }

    public CdsEntity getLastEntity() {
        String qualifiedName = this.edmUtils.getCdsEntityName((EdmEntityType)this.getLastEntityResource(true).getType());
        return this.globals.getModel().getEntity(qualifiedName);
    }

    public Map<String, Object> getBodyMap() {
        if (this.bodyMap == null) {
            this.bodyMap = this.remapBodyMap(this.extractBodyMap());
        }
        return this.bodyMap;
    }

    private Map<String, Object> extractBodyMap() {
        String elementName;
        CdsEntity entity;
        CdsType type;
        UriResourcePartTyped lastResource = this.getLastTypedResource();
        RequestBodyExtractor bodyExtractor = new RequestBodyExtractor(this.globals, this.odataRequest, this.requestFormat);
        if (lastResource.getKind() == UriResourceKind.function) {
            return bodyExtractor.extractBodyFromFunctionParameters(lastResource);
        }
        Optional<EdmProperty> edmProperty = this.edmUtils.getEdmProperty(lastResource);
        if (this.odataRequest.getMethod().equals((Object)HttpMethod.DELETE)) {
            return bodyExtractor.extractBodyFromProperty(edmProperty, lastResource);
        }
        if (this.requestFormat == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_CONTENT_TYPE, new Object[0]);
        }
        if (this.requestFormat.isCompatible(ContentType.TEXT_PLAIN) && !this.edmUtils.isEdmStream(edmProperty)) {
            return bodyExtractor.extractBodyFromPrimitiveValue(edmProperty, lastResource);
        }
        if (this.requestFormat.isCompatible(ContentType.APPLICATION_JSON) && !this.edmUtils.isEdmStream(edmProperty)) {
            return bodyExtractor.extractBodyFromJson(edmProperty, lastResource, this.getResponseType());
        }
        Charset charset = null;
        if (edmProperty.isPresent() && (type = (entity = this.getLastEntity()).getElement(elementName = this.edmxFlavourMapper.remap(edmProperty.get().getName(), (CdsStructuredType)entity)).getType()).isSimple() && CdsBaseType.cdsJavaMediaType((CdsBaseType)((CdsSimpleType)type.as(CdsSimpleType.class)).getType()) == Reader.class) {
            charset = ODataUtils.getCharset(this.requestFormat);
        }
        return bodyExtractor.extractBodyFromBinaryValue(edmProperty, lastResource, charset);
    }

    private Map<String, Object> remapBodyMap(Map<String, Object> bodyMap) {
        UriResourcePartTyped lastResource = this.getLastTypedResource();
        if (lastResource.getKind() == UriResourceKind.function || lastResource.getKind() == UriResourceKind.action) {
            CdsDefinition operation = this.edmUtils.getCdsOperation(this);
            Map<String, CdsType> parameters = this.edmUtils.getCdsOperationParameters(operation);
            for (String key : bodyMap.keySet()) {
                CdsType parameterType = parameters.get(key);
                if (!(parameterType instanceof CdsStructuredType)) continue;
                Object value = bodyMap.get(key);
                if (value instanceof Map) {
                    this.edmxFlavourMapper.remap((Map)value, (CdsStructuredType)parameterType.as(CdsStructuredType.class));
                    continue;
                }
                if (!(value instanceof List)) continue;
                this.edmxFlavourMapper.remap((List)value, (CdsStructuredType)parameterType.as(CdsStructuredType.class));
            }
            return bodyMap;
        }
        return this.edmxFlavourMapper.remap(bodyMap, (CdsStructuredType)this.getLastEntity());
    }

    public EdmType getResponseType() {
        UriResourcePartTyped lastResource = this.getLastTypedResource();
        if (lastResource != null) {
            return lastResource.getType();
        }
        return null;
    }

    public Preferences.Return getReturnPreference() {
        return this.globals.getOData().createPreferences((Collection)this.odataRequest.getHeaders("Prefer")).getReturn();
    }

    public boolean hasApply() {
        return this.getUriInfo() != null && this.getUriInfo().getApplyOption() != null;
    }

    public String getCorrelationId() {
        if (this.correlationId == null) {
            this.correlationId = CorrelationIdUtils.getOrGenerateCorrelationId((ParameterInfo)this);
        }
        return this.correlationId;
    }

    public String getHeader(String id) {
        return this.odataRequest.getHeader(id);
    }

    public Map<String, String> getHeaders() {
        return this.odataRequest.getAllHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getHeader((String)e.getKey())));
    }

    public String getQueryParameter(String key) {
        return this.queryParameters.get(key);
    }

    public Map<String, String> getQueryParams() {
        return this.queryParameters;
    }

    public Stream<String> getQueryParameters() {
        return this.queryParameters.keySet().stream();
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = new LocaleUtils(this.globals.getRuntime().getEnvironment().getCdsProperties()).getLocale(this.getQueryParameter("sap-language"), this.getHeader("x-sap-request-language"), this.getHeader("Accept-Language"));
        }
        return this.locale;
    }

    public Instant getValidFrom() {
        if (this.validFrom == null) {
            this.initTemporalRange();
        }
        return this.validFrom;
    }

    public Instant getValidTo() {
        if (this.validTo == null) {
            this.initTemporalRange();
        }
        return this.validTo;
    }

    private void initTemporalRange() {
        Instant[] range = TemporalRangeUtils.getTemporalRanges((String)this.getQueryParameter("sap-valid-from"), (String)this.getQueryParameter("sap-valid-to"), (String)this.getQueryParameter("sap-valid-at"));
        this.validFrom = range[0];
        this.validTo = range[1];
    }
}

