/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;

public class FilterByAggregateTransformation
implements Transformation {
    private static final RefSegment OUTER = CQL.refSegment((String)"$outer");
    private final List<GroupByItem> gByItems;
    private final Expression filter;
    private final ExpressionParser expressionParser;

    public FilterByAggregateTransformation(List<GroupByItem> gByItems, Expression filter, ExpressionParser expressionParser) {
        this.gByItems = gByItems;
        this.filter = filter;
        this.expressionParser = expressionParser;
    }

    @Override
    public Select<?> apply(Select<?> select) {
        Select inner = Select.copy(select);
        ArrayList<ElementRef> dimensions = new ArrayList<ElementRef>(this.gByItems.size());
        ArrayList<Predicate> innerToOuter = new ArrayList<Predicate>(this.gByItems.size());
        for (GroupByItem gByItem : this.gByItems) {
            List path = gByItem.getPath();
            ElementRef ref = CQL.get(this.expressionParser.toSegmentList(path));
            innerToOuter.add(this.eq(ref, FilterByAggregateTransformation.outer(ref)));
            dimensions.add(ref);
        }
        inner.groupBy(dimensions);
        inner.columns(dimensions.stream().map(r -> r.as(this.structuredAlias((ElementRef<?>)r))));
        inner.where((CqnPredicate)innerToOuter.stream().collect(Conjunction.and()));
        inner.having((CqnPredicate)this.expressionParser.parseFilter(this.filter));
        select.where(e -> e.exists(o -> inner));
        return select;
    }

    private Predicate eq(ElementRef<?> ref, ElementRef<?> outer) {
        return CQL.comparison(ref, (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.EQ, outer);
    }

    @Override
    public int rank() {
        return 2;
    }

    private String structuredAlias(ElementRef<?> ref) {
        return ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
    }

    private static ElementRef<?> outer(ElementRef<?> ref) {
        List refSegments = ref.segments();
        ArrayList<RefSegment> segments = new ArrayList<RefSegment>(refSegments.size() + 1);
        segments.add(OUTER);
        segments.addAll(refSegments);
        return CQL.get(segments);
    }
}

