/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.apply.OrderBy;

public class OrderByTransformation
implements Transformation {
    private final OrderByOption orderBy;
    private final ExpressionParser expressionParser;

    public OrderByTransformation(OrderByOption orderBy, ExpressionParser expressionParser) {
        this.orderBy = orderBy;
        this.expressionParser = expressionParser;
    }

    public OrderByTransformation(OrderBy orderBy, ExpressionParser expressionParser) {
        this(orderBy.getOrderByOption(), expressionParser);
    }

    public List<CqnSortSpecification> convertOrderByOption(List<CqnSelectListItem> items) {
        ArrayList<CqnSortSpecification> sortList = new ArrayList<CqnSortSpecification>();
        AliasResolver aliasResolver = new AliasResolver(items);
        for (OrderByItem order : this.orderBy.getOrders()) {
            Value<?> value = this.expressionParser.parseValue(order.getExpression());
            CqnSelectListValue slv = aliasResolver.findByValue((CqnValue)value).orElse(OrderByTransformation.getAliasForExpression(value));
            CqnSortSpecification sortSpec = CQL.sort((CqnValue)slv.value(), (CqnSortSpecification.Order)(order.isDescending() ? CqnSortSpecification.Order.DESC : CqnSortSpecification.Order.ASC));
            sortList.add(sortSpec);
        }
        return sortList;
    }

    private static CqnSelectListValue getAliasForExpression(Value<?> value) {
        SelectListValueBuilder slv = SelectListValueBuilder.select(value);
        if (value.isFunction()) {
            RefVisitor v = new RefVisitor();
            value.accept((CqnVisitor)v);
            slv.as(v.alias);
        }
        return slv.build();
    }

    @Override
    public Select<?> apply(Select<?> select) {
        return select.orderBy(this.convertOrderByOption(select.items()));
    }

    @Override
    public int rank() {
        return 3;
    }

    private static boolean couldBeAlias(CqnElementRef ref) {
        List segments = ref.segments();
        return segments.size() == 1 && !((CqnReference.Segment)segments.get(0)).filter().isPresent();
    }

    private static class RefVisitor
    implements CqnVisitor {
        private String alias = "";

        private RefVisitor() {
        }

        public void visit(CqnElementRef elementRef) {
            this.alias = elementRef.displayName();
        }
    }

    private static class AliasResolver {
        Map<String, CqnSelectListValue> mapping;

        AliasResolver(List<CqnSelectListItem> items) {
            this.mapping = items.stream().filter(CqnSelectListItem::isValue).map(CqnSelectListItem::asValue).collect(Collectors.toMap(CqnSelectListValue::displayName, Function.identity()));
        }

        Optional<CqnSelectListValue> findByValue(CqnValue value) {
            if (value.isRef() && OrderByTransformation.couldBeAlias(value.asRef())) {
                return Optional.ofNullable(this.mapping.get(value.asRef().firstSegment()));
            }
            return Optional.empty();
        }
    }
}

