/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsOperationNotFoundException;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;

public class EdmUtils {
    private static final String PARAMETERS = "Parameters";
    private static final String TYPE = "Type";
    private static final String SET = "Set";
    private final CdsRequestGlobals globals;

    public EdmUtils(CdsRequestGlobals globals) {
        this.globals = globals;
    }

    public EdmBindingTarget getEdmBindingTarget(EdmEntityType entityType) {
        String entityTypeName;
        EdmEntitySet target = null;
        EdmEntityContainer container = this.globals.getServiceMetadata().getEdm().getEntityContainer();
        target = container.getEntitySet(entityTypeName = entityType.getName());
        if (target != null) {
            return target;
        }
        target = container.getSingleton(entityTypeName);
        if (target != null) {
            return target;
        }
        if (this.isParametersEntityType(entityType) && (target = container.getEntitySet(entityTypeName = entityTypeName.substring(0, entityTypeName.length() - PARAMETERS.length()))) != null) {
            return target;
        }
        return target;
    }

    public boolean isParametersEntityType(EdmEntityType entityType) {
        String setName;
        EdmNavigationProperty setNavigation;
        String name = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        return name.endsWith(PARAMETERS) && (setNavigation = entityType.getNavigationProperty(SET)) != null && (setName = setNavigation.getType().getFullQualifiedName().getFullQualifiedNameAsString()).endsWith(TYPE) && name.startsWith(setName.substring(0, setName.length() - TYPE.length()));
    }

    public boolean isSetEntityType(EdmEntityType entityType) {
        String paramName;
        EdmNavigationProperty paramNavigation;
        String name = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        return name.endsWith(TYPE) && (paramNavigation = entityType.getNavigationProperty(PARAMETERS)) != null && (paramName = paramNavigation.getType().getFullQualifiedName().getFullQualifiedNameAsString()).endsWith(PARAMETERS) && name.startsWith(paramName.substring(0, paramName.length() - PARAMETERS.length()));
    }

    public String getCdsEntityName(EdmEntityType entityType) {
        String name = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        if (this.isSetEntityType(entityType)) {
            name = name.substring(0, name.length() - TYPE.length());
        } else if (this.isParametersEntityType(entityType)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PARAMETERIZED_VIEW, new Object[0]);
        }
        String cdsName = this.globals.getCdsEntityNames().get(name);
        if (cdsName != null) {
            name = cdsName;
        }
        return name;
    }

    public CdsStructuredType findStructuredType(EdmType type) {
        if (type.getKind() == EdmTypeKind.ENTITY) {
            String entityName = this.getCdsEntityName((EdmEntityType)type);
            return this.globals.getModel().getEntity(entityName);
        }
        if (type.getKind() == EdmTypeKind.COMPLEX) {
            String structName = type.getFullQualifiedName().getFullQualifiedNameAsString();
            return this.globals.getModel().getStructuredType(structName);
        }
        return null;
    }

    public EdmOperation getEdmOperation(UriResource resource) {
        if (resource.getKind() == UriResourceKind.action) {
            return ((UriResourceAction)resource).getAction();
        }
        if (resource.getKind() == UriResourceKind.function) {
            return ((UriResourceFunction)resource).getFunction();
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
    }

    public CdsDefinition getCdsOperation(CdsODataRequest request) {
        EdmOperation operation = this.getEdmOperation((UriResource)request.getLastTypedResource());
        if (operation.getKind() == EdmTypeKind.ACTION) {
            if (operation.isBound()) {
                return request.getLastEntity().getAction(operation.getName());
            }
            CdsService service = this.globals.getApplicationService().getDefinition();
            return (CdsDefinition)service.actions().filter(a -> a.getName().equals(operation.getName())).findFirst().orElseThrow(() -> new CdsOperationNotFoundException(CdsKind.ACTION, operation.getName(), (CdsDefinition)service));
        }
        if (operation.getKind() == EdmTypeKind.FUNCTION) {
            if (operation.isBound()) {
                return request.getLastEntity().getFunction(operation.getName());
            }
            CdsService service = this.globals.getApplicationService().getDefinition();
            return (CdsDefinition)service.functions().filter(a -> a.getName().equals(operation.getName())).findFirst().orElseThrow(() -> new CdsOperationNotFoundException(CdsKind.FUNCTION, operation.getName(), (CdsDefinition)service));
        }
        return null;
    }

    public CdsType getCdsOperationReturnType(CdsDefinition operation) {
        CdsType type = null;
        if (operation instanceof CdsAction) {
            type = ((CdsAction)operation.as(CdsAction.class)).returnType().orElse(null);
        } else if (operation instanceof CdsFunction) {
            type = ((CdsFunction)operation.as(CdsFunction.class)).getReturnType();
        }
        return this.stripArrayed(type);
    }

    public Map<String, CdsType> getCdsOperationParameters(CdsDefinition operation) {
        Stream parameters = Stream.empty();
        if (operation instanceof CdsAction) {
            parameters = ((CdsAction)operation.as(CdsAction.class)).parameters();
        } else if (operation instanceof CdsFunction) {
            parameters = ((CdsFunction)operation.as(CdsFunction.class)).parameters();
        }
        HashMap<String, CdsType> parameterMap = new HashMap<String, CdsType>();
        parameters.forEach(p -> parameterMap.put(p.getName(), this.stripArrayed(p.getType())));
        return parameterMap;
    }

    private CdsType stripArrayed(CdsType type) {
        if (type != null && type.isArrayed()) {
            return this.stripArrayed(((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType());
        }
        return type;
    }

    public Optional<EdmProperty> getEdmProperty(UriResourcePartTyped resource) {
        if (resource instanceof UriResourcePrimitiveProperty) {
            return Optional.of(((UriResourcePrimitiveProperty)resource).getProperty());
        }
        if (resource instanceof UriResourceComplexProperty) {
            return Optional.of(((UriResourceComplexProperty)resource).getProperty());
        }
        return Optional.empty();
    }

    public boolean isEdmStream(Optional<EdmProperty> edmProperty) {
        if (edmProperty.isPresent()) {
            return edmProperty.get().getType() instanceof EdmStream;
        }
        return false;
    }
}

