/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.utils.MessagesUtils;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ErrorResponseEventContext;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.ex.ODataErrorDetail;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceFunction;

public class ODataUtils {
    private static final String DEFAULT_BINDING_PARAMETER = "in";
    private static final String BINDING_PARAMETER_ANNOTATION = "cds.odata.bindingparameter.name";

    public static ODataSerializer createSerializer(OData odata, ODataRequest odataRequest, org.apache.olingo.commons.api.format.ContentType responseFormat) {
        try {
            return odata.createSerializer(responseFormat, Arrays.asList(ODataUtils.getODataVersion(odataRequest)));
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[]{e});
        }
    }

    public static EdmAssistedSerializer createSerializerForApply(OData odata, org.apache.olingo.commons.api.format.ContentType responseFormat) {
        try {
            return odata.createEdmAssistedSerializer(responseFormat);
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[]{e});
        }
    }

    public static String getODataVersion(ODataRequest odataRequest) {
        String odataVersion = odataRequest.getHeader("OData-Version");
        String odataMaxVersion = odataRequest.getHeader("OData-MaxVersion");
        return ODataUtils.getODataVersion(odataVersion, odataMaxVersion);
    }

    public static String getODataVersion(String odataVersion, String odataMaxVersion) {
        String version;
        String string = version = odataVersion != null && ODataServiceVersion.isValidODataVersion((String)odataVersion) ? odataVersion : "4.01";
        if (odataMaxVersion != null && ODataServiceVersion.isValidMaxODataVersion((String)odataMaxVersion) && Double.parseDouble(odataMaxVersion) < Double.parseDouble(version)) {
            version = odataMaxVersion;
        }
        return version;
    }

    public static String getBindingParameter(CdsModel model, UriInfo uriInfo) {
        int lastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (lastPathSegment.getKind()) {
            case action: {
                UriResourceAction uriResourceAction = (UriResourceAction)lastPathSegment;
                EdmAction action = uriResourceAction.getAction();
                return ODataUtils.getBindingParameter(model, (EdmOperation)action);
            }
            case function: {
                UriResourceFunction uriResourceFunction = (UriResourceFunction)lastPathSegment;
                EdmFunction function = uriResourceFunction.getFunction();
                return ODataUtils.getBindingParameter(model, (EdmOperation)function);
            }
        }
        return null;
    }

    private static String getBindingParameter(CdsModel model, EdmOperation operation) {
        String fullQualifiedBoundEntityName;
        Optional foundEntity;
        if (operation.isBound() && (foundEntity = model.findEntity(fullQualifiedBoundEntityName = operation.getBindingParameterTypeFqn().getFullQualifiedNameAsString())).isPresent()) {
            switch (operation.getKind()) {
                case ACTION: {
                    return ((CdsEntity)foundEntity.get()).findAction(operation.getName()).map(a -> (String)a.getAnnotationValue(BINDING_PARAMETER_ANNOTATION, (Object)DEFAULT_BINDING_PARAMETER)).orElse(null);
                }
                case FUNCTION: {
                    return ((CdsEntity)foundEntity.get()).findFunction(operation.getName()).map(a -> (String)a.getAnnotationValue(BINDING_PARAMETER_ANNOTATION, (Object)DEFAULT_BINDING_PARAMETER)).orElse(null);
                }
            }
            return null;
        }
        return null;
    }

    public static CdsODataResponse toErrorResponse(ServiceException e, CdsRequestGlobals globals) {
        ApplicationLifecycleService applicationLifecycleService = (ApplicationLifecycleService)globals.getRuntime().getServiceCatalog().getService(ApplicationLifecycleService.class, "ApplicationLifecycleService$Default");
        ErrorResponseEventContext.ErrorResponse errorResponse = applicationLifecycleService.errorResponse(e);
        return new CdsODataResponse(errorResponse);
    }

    public static void setODataErrorResponse(OData odata, ODataRequest odataRequest, ODataResponse odataResponse, CdsODataResponse cdsResponse, String bindingParameter, org.apache.olingo.commons.api.format.ContentType responseFormat) {
        String contentId = odataRequest.getHeader("Content-ID");
        ODataServerError serverError = new ODataServerError();
        List<Message> errorMessages = cdsResponse.getErrorMessages();
        Message first = errorMessages.get(0);
        serverError.setStatusCode(cdsResponse.getStatusCode());
        serverError.setCode(first.getCode() != null ? first.getCode() : String.valueOf(cdsResponse.getStatusCode()));
        serverError.setMessage(first.getMessage());
        serverError.setTarget(MessagesUtils.getTarget(bindingParameter, first.getTarget()));
        serverError.setAdditionalProperties(ODataUtils.buildAdditionalProperties(null, null, contentId));
        List details = errorMessages.stream().skip(1L).map(m -> {
            ODataErrorDetail errorDetail = new ODataErrorDetail();
            errorDetail.setCode(MessagesUtils.getMessageCode(m));
            errorDetail.setMessage(m.getMessage());
            errorDetail.setTarget(MessagesUtils.getTarget(bindingParameter, m.getTarget()));
            errorDetail.setAdditionalProperties(ODataUtils.buildAdditionalProperties(m.getSeverity().getNumericSeverity(), m.getLongTextUrl(), contentId));
            return errorDetail;
        }).collect(Collectors.toList());
        if (!details.isEmpty()) {
            serverError.setDetails(details);
        }
        odataResponse.setStatusCode(cdsResponse.getStatusCode());
        odataResponse.setHeader("Content-Type", responseFormat.toContentTypeString());
        odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(odataRequest));
        try {
            odataResponse.setContent(ODataUtils.createSerializer(odata, odataRequest, responseFormat).error(serverError).getContent());
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
        }
    }

    private static Map<String, Object> buildAdditionalProperties(Integer severity, String longtextUrl, String contentId) {
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
        if (severity != null) {
            additionalProperties.put("@Common.numericSeverity", severity);
        }
        if (longtextUrl != null) {
            additionalProperties.put("@Common.longtextUrl", longtextUrl);
        }
        if (contentId != null) {
            additionalProperties.put("@Core.ContentID", contentId);
        }
        return additionalProperties.isEmpty() ? null : additionalProperties;
    }

    public static Charset getCharset(org.apache.olingo.commons.api.format.ContentType contentType) {
        Charset charset = StandardCharsets.UTF_8;
        String charsetFromContentType = contentType.getParameter("charset");
        if (!StringUtils.isEmpty((String)charsetFromContentType)) {
            try {
                charset = Charset.forName(charsetFromContentType);
            }
            catch (IllegalArgumentException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CHARSET, new Object[0]);
            }
        } else {
            String mimeType = contentType.getType() + "/" + contentType.getSubtype();
            ContentType apacheContentType = ContentType.getByMimeType((String)mimeType);
            if (apacheContentType != null && apacheContentType.getCharset() != null) {
                charset = apacheContentType.getCharset();
            }
        }
        return charset;
    }
}

