/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.AbstractODataProcessor;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.processors.response.ResultSetProcessor;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v4.utils.ChangeSetContextAwareInputStream;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.PrimitiveValueSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilderImpl;

public class ODataProcessor
extends AbstractODataProcessor {
    private final ResultSetProcessor resultSetProcessor;

    public ODataProcessor(CdsRequestGlobals globals) {
        super(globals);
        this.resultSetProcessor = new ResultSetProcessor(globals);
    }

    @Override
    public void processEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            ExpandOption expand;
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            Entity entity = this.resultSetProcessor.toEntity((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expandOption = expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            if (entity != null && odataRequest.getMethod() != HttpMethod.GET && cdsRequest.getLastResource() == cdsRequest.getLastEntityResource(true)) {
                String location = odataRequest.getRawBaseUri() + odataRequest.getRawODataPath();
                UriResource lastResource = cdsRequest.getLastResource();
                if (!location.endsWith(")") && (lastResource.getKind() == UriResourceKind.entitySet || lastResource.getKind() == UriResourceKind.navigationProperty && ((UriResourceNavigation)lastResource).getProperty().isCollection())) {
                    try {
                        String keyPredicate = this.globals.getOData().createUriHelper().buildKeyPredicate((EdmEntityType)cdsRequest.getResponseType(), entity);
                        if (!StringUtils.isEmpty((String)keyPredicate)) {
                            location = location + '(' + keyPredicate + ')';
                        }
                    }
                    catch (SerializerException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                    }
                }
                odataResponse.setHeader("Location", location);
                odataResponse.setHeader("OData-EntityID", location);
            }
            SerializerResult serializerResult = null;
            if (entity != null) {
                String etag = entity.getETag();
                if (etag != null) {
                    odataResponse.setHeader("ETag", etag);
                }
                if (cdsResponse.getStatusCode() < 204 && cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                    this.checkCountOptionsOnExpand(entity, uriInfo.getExpandOption());
                    ContextURL contextUrl = this.getContextUrl((CdsODataRequest)cdsRequest, false, uriInfo.getSelectOption(), expand);
                    EntitySerializerOptions options = EntitySerializerOptions.with().contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(expand).build();
                    try {
                        serializerResult = this.createSerializer(odataRequest, responseFormat).entity(this.globals.getServiceMetadata(), (EdmEntityType)cdsRequest.getResponseType(), entity, options);
                    }
                    catch (SerializerException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                    }
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    @Override
    public void processEntities(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            SerializerResult serializerResult;
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            EntityCollection entityCollection = this.resultSetProcessor.toEntityCollection((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            entityCollection.forEach(entity -> this.checkCountOptionsOnExpand((Entity)entity, uriInfo.getExpandOption()));
            NextLinkInfo nextLinkInfo = cdsResponse.getNextLinkInfo();
            if (nextLinkInfo != null) {
                URI nextLink = nextLinkInfo.getNextLink(odataRequest);
                entityCollection.setNext(nextLink);
            }
            ODataProcessor.setInlineCount(uriInfo, cdsResponse.getResult(), entityCollection);
            try {
                ContextURL contextUrl = this.getContextUrl((CdsODataRequest)cdsRequest, true, uriInfo.getSelectOption(), expand);
                if (uriInfo.getApplyOption() != null) {
                    EdmAssistedSerializerOptions optionsForApply = EdmAssistedSerializerOptions.with().contextURL(contextUrl).build();
                    serializerResult = this.createSerializerForApply(odataRequest, responseFormat).entityCollection(this.globals.getServiceMetadata(), (EdmEntityType)cdsRequest.getResponseType(), (AbstractEntityCollection)entityCollection, optionsForApply);
                } else {
                    EntityCollectionSerializerOptions options = EntityCollectionSerializerOptions.with().contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(expand).count(uriInfo.getCountOption()).build();
                    serializerResult = this.createSerializer(odataRequest, responseFormat).entityCollection(this.globals.getServiceMetadata(), (EdmEntityType)cdsRequest.getResponseType(), (AbstractEntityCollection)entityCollection, options);
                }
            }
            catch (SerializerException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, serializerResult.getContent(), responseFormat);
        });
    }

    @Override
    public void processSingleComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            Property complexProperty = this.resultSetProcessor.toComplex((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            SerializerResult serializerResult = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, false, uriInfo.getSelectOption(), expand);
                ComplexSerializerOptions options = ComplexSerializerOptions.with().contextURL(contextURL).select(uriInfo.getSelectOption()).expand(expand).build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).complex(this.globals.getServiceMetadata(), (EdmComplexType)cdsRequest.getResponseType(), complexProperty, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    @Override
    public void processCollectionComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            Property complexProperty = this.resultSetProcessor.toComplexCollection((CdsODataRequest)cdsRequest, cdsResponse.getResult(), expandBuilder);
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : expandBuilder.build();
            SerializerResult serializerResult = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, true, uriInfo.getSelectOption(), expand);
                ComplexSerializerOptions options = ComplexSerializerOptions.with().contextURL(contextURL).select(uriInfo.getSelectOption()).expand(expand).build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).complexCollection(this.globals.getServiceMetadata(), (EdmComplexType)cdsRequest.getResponseType(), complexProperty, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    @Override
    public void processSinglePrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        ChangeSetContextSPI changeSetContext;
        if (this.isGetStreamContext(odataRequest, uriInfo, requestFormat)) {
            changeSetContext = ChangeSetContextSPI.open();
            this.globals.getUnclosedChangeSetTracker().set(true);
        } else {
            changeSetContext = null;
        }
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            Object content;
            SerializerResult serializerResult = null;
            Property property = this.resultSetProcessor.toPrimitive((CdsODataRequest)cdsRequest, cdsResponse.getResult());
            boolean isStream = cdsRequest.getLastTypedResource().getType() instanceof EdmStream;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL && !isStream) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, false, null, null);
                PrimitiveSerializerOptions.Builder builder = PrimitiveSerializerOptions.with().contextURL(contextURL);
                this.getEdmProperty((CdsODataRequest)cdsRequest).ifPresent(edmProp -> builder.facetsFrom(edmProp));
                PrimitiveSerializerOptions options = builder.build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).primitive(this.globals.getServiceMetadata(), (EdmPrimitiveType)cdsRequest.getResponseType(), property, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            ContentType contentType = !StringUtils.isEmpty((String)cdsResponse.getContentType()) ? ContentType.create((String)cdsResponse.getContentType()) : responseFormat;
            if (changeSetContext != null && property.getValue() != null) {
                InputStream stream;
                if (property.getValue() instanceof Reader) {
                    Charset charset = ODataUtils.getCharset(contentType);
                    stream = new ReaderInputStream((Reader)property.getValue(), charset);
                } else {
                    stream = (InputStream)property.getValue();
                }
                content = new ChangeSetContextAwareInputStream(stream, changeSetContext, this.globals.getUnclosedChangeSetTracker());
            } else {
                content = serializerResult != null ? serializerResult.getContent() : null;
            }
            this.setContentDispositionHeaderIfNotNull(odataResponse, cdsResponse.getContentDispositionFilename());
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, (InputStream)content, contentType);
        });
    }

    @Override
    public void processSinglePrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            if (this.isValueRequestOnStreamProperty((CdsODataRequest)cdsRequest)) {
                UriResourcePartTyped lastTypedResource = cdsRequest.getLastTypedResource();
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_ACCESS_NOT_ALLOWED, new Object[]{lastTypedResource.getSegmentValue()});
            }
            Property property = this.resultSetProcessor.toPrimitive((CdsODataRequest)cdsRequest, cdsResponse.getResult());
            Object value = property.getValue();
            InputStream content = null;
            if (value != null && cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                PrimitiveValueSerializerOptions.Builder builder = PrimitiveValueSerializerOptions.with();
                this.getEdmProperty((CdsODataRequest)cdsRequest).ifPresent(edmProp -> builder.facetsFrom(edmProp));
                PrimitiveValueSerializerOptions options = builder.build();
                try {
                    content = this.globals.getOData().createFixedFormatSerializer().primitiveValue((EdmPrimitiveType)cdsRequest.getResponseType(), value, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }

    @Override
    public void processCollectionPrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            Property property = this.resultSetProcessor.toPrimitiveCollection((CdsODataRequest)cdsRequest, cdsResponse.getResult());
            SerializerResult serializerResult = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, true, null, null);
                PrimitiveSerializerOptions options = PrimitiveSerializerOptions.with().contextURL(contextURL).build();
                try {
                    serializerResult = this.createSerializer(odataRequest, responseFormat).primitiveCollection(this.globals.getServiceMetadata(), (EdmPrimitiveType)cdsRequest.getResponseType(), property, options);
                }
                catch (SerializerException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
                }
            }
            InputStream content = serializerResult != null ? serializerResult.getContent() : null;
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, responseFormat);
        });
    }
}

