/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json;

import com.sap.cds.adapter.odata.v4.serializer.json.NavigationProperty2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.NavigationProperty2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.Struct2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.StructTypeHelper;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.api.PropertyInfo;
import com.sap.cds.adapter.odata.v4.serializer.json.options.NavigationProperty2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.options.Struct2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.adapter.odata.v4.utils.StreamUtils;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.utils.ETagUtils;
import com.sap.cds.services.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.olingo.commons.api.IConstants;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectItemImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectOptionImpl;

public abstract class Struct2JsonBuilder {
    protected final Struct2JsonOptions options;
    protected final EdmStructuredType structType;
    protected IConstants constants;
    protected String eTagProperty;
    protected ServiceMetadata metadata;
    protected Set<String> selected = null;
    protected boolean hasExpand;
    protected ExpandItem expandAll;
    protected String resourceName;
    protected ContentType contentType;

    protected Struct2JsonBuilder(Struct2JsonOptions options, EdmStructuredType structType) {
        this.options = options;
        this.structType = structType;
        this.resourceName = options.getContextURL() == null ? null : options.getContextURL().getEntitySetOrSingletonOrType();
    }

    protected EdmStructuredType structType() {
        return this.structType;
    }

    protected void addContextAnnotation(Struct2Json struct2json, boolean withETag) {
        if (!this.options.isODataMetadataNone()) {
            if (this.options.getContextURL() != null) {
                struct2json.context = String2Json.val(this.constants.getContext(), ContextURLBuilder.create((ContextURL)this.options.getContextURL()).toASCIIString());
                if (this.metadata.getServiceMetadataETagSupport() != null && this.metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
                    struct2json.metadataEtag = String2Json.val(this.constants.getMetadataEtag(), this.metadata.getServiceMetadataETagSupport().getMetadataETag());
                }
            }
            this.eTagProperty = withETag ? ETagHelper.getETagProperty(this.options.getGlobals(), this.structType) : null;
        }
    }

    protected void createSelectList() {
        if (!ExpandSelectHelper.isAll((SelectOption)this.options.getSelect())) {
            this.selected = ExpandSelectHelper.getSelectedPropertyNames((List)this.options.getSelect().getSelectItems());
        }
    }

    protected void addTypeAnnotation(Struct2Json struct2json) {
        EdmStructuredType resolvedType = StructTypeHelper.resolveEntityType(this.metadata, this.structType, this.options.getDerivedTypeName());
        if (this.options.isODataMetadataFull() || !this.options.isODataMetadataNone() && !resolvedType.equals(this.structType)) {
            struct2json.type = String2Json.val(this.constants.getType(), "#" + this.structType.getFullQualifiedName().getFullQualifiedNameAsString());
        }
    }

    protected void createProperties(Struct2Json struct2json) {
        struct2json.primitiveProperties = this.createPrimitiveAndComplexProperties(struct2json, this.structType, this.eTagProperty, this.selected);
        struct2json.navigationProperties = this.createNavigationProperties();
    }

    public void addDynamicExpandProperties(Struct2Json struct2json, Set<String> potentialDynamicProperties) {
        struct2json.dynamicProperties = new ArrayList<Data2Json<Map<String, Object>>>();
        Iterator<String> it = potentialDynamicProperties.iterator();
        while (it.hasNext()) {
            String p = it.next();
            if (!this.structType.getNavigationPropertyNames().contains(p)) continue;
            EdmElement navigationProperty = this.structType.getProperty(p);
            NavigationProperty2JsonOptions navOptions = NavigationProperty2JsonOptions.with(this.contentType, this.options.getODataVersion(), this.options.getGlobals()).contextURL(this.options.getContextURL()).writeOnlyReferences(this.options.getWriteOnlyReferences()).autoExpand(this.options.isAutoExpand()).build();
            struct2json.dynamicProperties.add(NavigationProperty2JsonBuilder.createNavigation(navigationProperty, this.contentType, navOptions, false));
            it.remove();
        }
        if (null == struct2json.excludedProperties) {
            struct2json.excludedProperties = potentialDynamicProperties;
        } else {
            struct2json.excludedProperties.addAll(potentialDynamicProperties);
        }
    }

    private List<Data2Json<Map<String, Object>>> createNavigationProperties() {
        ArrayList<Data2Json<Map<String, Object>>> navigationProperties = new ArrayList<Data2Json<Map<String, Object>>>(this.structType.getNavigationPropertyNames().size());
        this.hasExpand = ExpandSelectHelper.hasExpand((ExpandOption)this.options.getExpand());
        if (this.hasExpand) {
            this.expandAll = ExpandSelectHelper.getExpandAll((ExpandOption)this.options.getExpand());
        }
        for (String navigationPropertyName : this.structType.getNavigationPropertyNames()) {
            this.addNavigationLink(navigationPropertyName);
            if (!this.hasExpand) continue;
            EdmElement navigationProperty = this.structType.getProperty(navigationPropertyName);
            ExpandItem innerExpandItem = ExpandSelectHelper.getExpandItemBasedOnType((List)this.options.getExpand().getExpandItems(), (String)navigationPropertyName, (EdmStructuredType)this.structType, (String)this.resourceName);
            ExpandOption innerExpandOption = null;
            if (innerExpandItem != null) {
                innerExpandOption = innerExpandItem.getExpandOption();
            } else {
                if (this.expandAll == null) continue;
                innerExpandOption = this.expandAll.getExpandOption();
            }
            NavigationProperty2JsonOptions navOptions = NavigationProperty2JsonOptions.with(this.contentType, this.options.getODataVersion(), this.options.getGlobals()).contextURL(this.options.getContextURL()).expand(innerExpandOption).count(innerExpandItem == null ? null : innerExpandItem.getCountOption()).select(innerExpandItem == null ? null : innerExpandItem.getSelectOption()).writeOnlyReferences(this.options.getWriteOnlyReferences()).autoExpand(this.options.isAutoExpand()).build();
            navigationProperties.add(NavigationProperty2JsonBuilder.createNavigation(navigationProperty, this.contentType, navOptions, false));
        }
        return navigationProperties;
    }

    private List<Data2Json<Map<String, Object>>> createPrimitiveAndComplexProperties(Struct2Json struct2json, EdmStructuredType structType, String eTagProperty, Set<String> selected) {
        ArrayList<Data2Json<Map<String, Object>>> properties = new ArrayList<Data2Json<Map<String, Object>>>(2 * structType.getPropertyNames().size());
        for (String propertyName : structType.getPropertyNames()) {
            String2Json<Map<String, Object>> propertyMetaSerializer;
            if (Objects.equals(propertyName, eTagProperty)) {
                struct2json.etag = String2Json.val(this.constants.getEtag(), row -> ETagUtils.createETagHeaderValue((String)String.valueOf(row.get(propertyName))));
            }
            if (this.options.getWriteOnlyReferences() || !Struct2JsonBuilder.isSelected(selected, propertyName)) continue;
            PropertyInfo propertyInfo = PropertyInfo.from((EdmProperty)structType.getProperty(propertyName));
            if (this.options.isODataMetadataFull() && (propertyMetaSerializer = StructTypeHelper.createPropertyMetaTypeSerializer(propertyInfo, this.options)) != null) {
                properties.add(propertyMetaSerializer);
            }
            if (propertyInfo.getType() == EdmStream.getInstance()) {
                String entityName = this.options.getEdmUtils().getCdsEntityName(structType);
                CdsEntity entity = this.options.getGlobals().getModel().getEntity(entityName);
                String mediaTypeElement = StreamUtils.getCoreMediaTypeElement(entity, propertyName);
                String mediaContentType = StringUtils.isEmpty((String)mediaTypeElement) ? StreamUtils.getCoreMediaTypeValue(entity, propertyName) : null;
                Function<Map, String> contentTypeExtractor = row -> {
                    Object media = row.get(propertyName);
                    if (null != media) {
                        if (!StringUtils.isEmpty((String)mediaTypeElement)) {
                            return (String)row.get(mediaTypeElement);
                        }
                        return mediaContentType;
                    }
                    return null;
                };
                String2Json<Map> mediaContentTypeInfo = String2Json.val(propertyName + this.constants.getMediaContentType(), contentTypeExtractor);
                properties.add(mediaContentTypeInfo);
                continue;
            }
            if (propertyInfo.getType().getKind() == EdmTypeKind.COMPLEX) {
                NavigationProperty2Json navProperty = this.createNavigationComplexType(propertyName);
                if (null == navProperty) continue;
                properties.add(navProperty);
                continue;
            }
            properties.add(StructTypeHelper.createPropertySerializer(propertyInfo, this.options));
        }
        return properties;
    }

    private NavigationProperty2Json createNavigationComplexType(String navigationPropertyName) {
        EdmElement navigationProperty = this.structType.getProperty(navigationPropertyName);
        NavigationProperty2JsonOptions navOptions = NavigationProperty2JsonOptions.with(this.contentType, this.options.getODataVersion(), this.options.getGlobals()).expand(this.options.getExpand()).select(this.options.getSelect() == null ? null : this.getSelectOptionComplexType(navigationProperty)).build();
        return NavigationProperty2JsonBuilder.createNavigation(navigationProperty, this.contentType, navOptions, true);
    }

    private SelectOption getSelectOptionComplexType(EdmElement navigationProperty) {
        ArrayList<SelectItemImpl> selItems = new ArrayList<SelectItemImpl>();
        SelectOptionImpl selOpt = null;
        for (SelectItem si : this.options.getSelect().getSelectItems()) {
            List segments = si.getResourcePath().getUriResourceParts();
            if (segments.size() <= 1 || !navigationProperty.getName().equals(((UriResource)segments.get(0)).getSegmentValue())) continue;
            SelectItemImpl i = new SelectItemImpl();
            UriInfoImpl r = new UriInfoImpl();
            segments.stream().skip(1L).forEach(arg_0 -> ((UriInfoImpl)r).addResourcePart(arg_0));
            i.setResourcePath((UriInfoResource)r);
            selItems.add(i);
        }
        if (!selItems.isEmpty()) {
            selOpt = new SelectOptionImpl();
            selOpt.setSelectItems(selItems);
        }
        return selOpt;
    }

    protected abstract void addNavigationLink(String var1);

    private static boolean isSelected(Set<String> selected, String propertyName) {
        return selected == null || selected.contains(propertyName);
    }
}

