/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.util.CdsTypeUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGuid;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;

public class TypeConverterUtils {
    private TypeConverterUtils() {
    }

    public static Object convertToType(EdmType type, String value) {
        if (value == null) {
            return null;
        }
        Object theType = type.getKind() == EdmTypeKind.ENUM ? ((EdmEnumType)type).getUnderlyingType() : (type.getKind() == EdmTypeKind.DEFINITION ? ((EdmTypeDefinition)type).getUnderlyingType() : type);
        if (theType instanceof EdmPrimitiveType) {
            try {
                value = theType.fromUriLiteral(value);
            }
            catch (EdmPrimitiveTypeException edmPrimitiveTypeException) {
                // empty catch block
            }
        }
        Object typedValue = TypeConverterUtils.convertPrimitiveType((EdmType)theType, value);
        return typedValue;
    }

    private static Object convertPrimitiveType(EdmType type, String value) {
        Object typedValue = type instanceof EdmDecimal ? new BigDecimal(value) : (type instanceof EdmDouble ? Double.valueOf(Double.parseDouble(value)) : (type instanceof EdmSingle ? Float.valueOf(Float.parseFloat(value)) : (type instanceof EdmInt64 ? Long.valueOf(Long.parseLong(value)) : (type instanceof EdmInt32 || type instanceof EdmInt16 || type instanceof EdmSByte || type instanceof EdmByte ? Integer.valueOf(Integer.parseInt(value)) : (type instanceof EdmBinary ? (Object)value.getBytes(Charset.defaultCharset()) : (type instanceof EdmString ? value : (type instanceof EdmTimeOfDay ? LocalTime.parse(value) : (type instanceof EdmDate ? LocalDate.parse(value) : (type instanceof EdmDateTimeOffset ? ZonedDateTime.parse(value).toInstant() : (type instanceof EdmBoolean ? Boolean.valueOf(Boolean.parseBoolean(value)) : (type instanceof EdmGuid ? CdsTypeUtils.parseUuid((Object)value) : value)))))))))));
        return typedValue;
    }

    public static Object getValueBasedOnTypeOfResultSet(EdmType type, Object value) {
        if (value == null) {
            return null;
        }
        if (type instanceof EdmGuid) {
            value = UUID.fromString(value.toString());
        } else if (value instanceof String && (type instanceof EdmDateTimeOffset || type instanceof EdmDate || type instanceof EdmTimeOfDay)) {
            value = TypeConverterUtils.convertToType(type, (String)value);
        }
        return value;
    }

    public static Object getValueBasedOnTypeOfRequestPayload(String typeName, Object value) {
        if (typeName != null) {
            switch (typeName) {
                case "Edm.Guid": {
                    if (!(value instanceof UUID)) break;
                    value = value.toString();
                    break;
                }
                case "Edm.DateTimeOffset": {
                    if (!(value instanceof Timestamp)) break;
                    value = ((Timestamp)value).toInstant();
                    break;
                }
                case "Edm.Date": {
                    if (!(value instanceof GregorianCalendar)) break;
                    value = ((GregorianCalendar)value).toZonedDateTime().toLocalDate();
                    break;
                }
                case "Edm.TimeOfDay": {
                    if (!(value instanceof GregorianCalendar)) break;
                    value = ((GregorianCalendar)value).toZonedDateTime().toLocalTime();
                    break;
                }
                default: {
                    return value;
                }
            }
        }
        return value;
    }
}

