/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.edm.xml.Include;
import org.apache.olingo.client.api.edm.xml.Reference;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.ODataClientFactory;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataEdmProvider
extends CsdlAbstractEdmProvider {
    private XMLMetadata xmlMetadata;
    private volatile List<CsdlAliasInfo> csdlAliasInfo = null;

    public ODataEdmProvider(InputStream edmxFile) {
        ODataClient client = ODataClientFactory.getClient();
        this.xmlMetadata = client.getDeserializer(ContentType.APPLICATION_XML).toMetadata(edmxFile);
    }

    public XMLMetadata getXMLMetadata() {
        return this.xmlMetadata;
    }

    public boolean isV4Metadata() throws Exception {
        return ODataClientFactory.getClient().metadataValidation().isV4Metadata(this.xmlMetadata);
    }

    public boolean isServiceDocument() {
        return ODataClientFactory.getClient().metadataValidation().isServiceDocument(this.xmlMetadata);
    }

    public List<CsdlSchema> getSchemas() {
        return this.xmlMetadata.getSchemas();
    }

    public CsdlEntityContainer getEntityContainer() throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (csdlSchema.getEntityContainer() == null) continue;
            return csdlSchema.getEntityContainer();
        }
        return null;
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName entityContainerName) throws ODataException {
        CsdlEntityContainerInfo entityContainerInfo = new CsdlEntityContainerInfo();
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (csdlSchema.getEntityContainer() == null) continue;
            entityContainerInfo.setContainerName(new FullQualifiedName(csdlSchema.getNamespace(), csdlSchema.getEntityContainer().getName()));
            return entityContainerInfo;
        }
        return null;
    }

    public Reference getEDMXReference(FullQualifiedName name) {
        String namespace = name.getNamespace();
        List referenceList = this.xmlMetadata.getReferences();
        for (Reference ref : referenceList) {
            List includes = ref.getIncludes();
            for (Include include : includes) {
                if (!namespace.equals(include.getNamespace())) continue;
                return ref;
            }
        }
        return null;
    }

    public List<EdmxReference> getAllEDMXReference() {
        ArrayList<EdmxReference> edmxReferences = new ArrayList<EdmxReference>();
        List referenceList = this.xmlMetadata.getReferences();
        for (Reference ref : referenceList) {
            EdmxReference reference = new EdmxReference(ref.getUri());
            List includes = ref.getIncludes();
            for (Include include : includes) {
                reference.addInclude(new EdmxReferenceInclude(include.getNamespace(), include.getAlias()));
            }
            edmxReferences.add(reference);
        }
        return edmxReferences;
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName entityContainer, String entitySetName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        String fqnContainer = null;
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (csdlSchema.getEntityContainer() == null || !(fqnContainer = csdlSchema.getNamespace() + (String)(csdlSchema.getEntityContainer() != null ? "." + csdlSchema.getEntityContainer().getName() : "")).equals(entityContainer.getFullQualifiedNameAsString())) continue;
            return csdlSchema.getEntityContainer().getEntitySet(entitySetName);
        }
        return null;
    }

    public CsdlEntityType getEntityType(FullQualifiedName entityTypeName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!csdlSchema.getNamespace().equals(entityTypeName.getNamespace())) continue;
            return csdlSchema.getEntityType(entityTypeName.getName());
        }
        return null;
    }

    public List<EdmxReference> getReferences() {
        List refs = this.xmlMetadata.getReferences();
        ArrayList<EdmxReference> edmxRefList = null;
        if (!refs.isEmpty()) {
            for (Reference refTemp : refs) {
                EdmxReference reference = new EdmxReference(refTemp.getUri());
                for (Include includeTemp : refTemp.getIncludes()) {
                    reference.addInclude(new EdmxReferenceInclude(includeTemp.getNamespace(), includeTemp.getAlias()));
                }
                if (edmxRefList == null) {
                    edmxRefList = new ArrayList<EdmxReference>();
                    edmxRefList.add(reference);
                    continue;
                }
                edmxRefList.add(reference);
            }
            return edmxRefList;
        }
        return new ArrayList<EdmxReference>();
    }

    public CsdlComplexType getComplexType(FullQualifiedName complexTypeName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!csdlSchema.getNamespace().equals(complexTypeName.getNamespace())) continue;
            return csdlSchema.getComplexType(complexTypeName.getName());
        }
        return null;
    }

    public CsdlFunctionImport getFunctionImport(FullQualifiedName entityContainer, String functionImportName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        CsdlFunctionImport funImport = null;
        String fqnContainer = null;
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (csdlSchema.getEntityContainer() == null || !(fqnContainer = csdlSchema.getNamespace() + (String)(csdlSchema.getEntityContainer() != null ? "." + csdlSchema.getEntityContainer().getName() : "")).equals(entityContainer.getFullQualifiedNameAsString())) continue;
            funImport = csdlSchema.getEntityContainer().getFunctionImport(functionImportName);
            break;
        }
        return funImport;
    }

    public List<CsdlFunction> getFunctions(FullQualifiedName functionName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!Objects.equals(csdlSchema.getNamespace(), functionName.getNamespace()) && !Objects.equals(csdlSchema.getAlias(), functionName.getNamespace())) continue;
            return csdlSchema.getFunctions(functionName.getName());
        }
        return null;
    }

    public CsdlActionImport getActionImport(FullQualifiedName entityContainer, String actionImportName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        String fqnContainer = null;
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (csdlSchema.getEntityContainer() == null || !(fqnContainer = csdlSchema.getNamespace() + "." + (csdlSchema.getEntityContainer() != null ? csdlSchema.getEntityContainer().getName() : "")).equals(entityContainer.getFullQualifiedNameAsString())) continue;
            return csdlSchema.getEntityContainer().getActionImport(actionImportName);
        }
        return null;
    }

    public List<CsdlAction> getActions(FullQualifiedName actionName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!Objects.equals(csdlSchema.getNamespace(), actionName.getNamespace()) && !Objects.equals(csdlSchema.getAlias(), actionName.getNamespace())) continue;
            return csdlSchema.getActions(actionName.getName());
        }
        return Collections.emptyList();
    }

    public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName, String qualifier) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        Iterator iterator = csdlSchemas.iterator();
        if (iterator.hasNext()) {
            CsdlSchema csdlSchema = (CsdlSchema)iterator.next();
            return csdlSchema.getAnnotationGroup(targetName.getFullQualifiedNameAsString(), qualifier);
        }
        return null;
    }

    public CsdlTypeDefinition getTypeDefinition(FullQualifiedName typeDefinitionName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!csdlSchema.getNamespace().equals(typeDefinitionName.getNamespace())) continue;
            return csdlSchema.getTypeDefinition(typeDefinitionName.getName());
        }
        if ("PropertyPath".equals(typeDefinitionName.getName())) {
            return new CsdlTypeDefinition().setName("PropertyPath").setUnderlyingType(new FullQualifiedName("Edm", "String"));
        }
        if ("NavigationPropertyPath".equals(typeDefinitionName.getName())) {
            return new CsdlTypeDefinition().setName("NavigationPropertyPath").setUnderlyingType(new FullQualifiedName("Edm", "String"));
        }
        if ("AnnotationPath".equals(typeDefinitionName.getName())) {
            return new CsdlTypeDefinition().setName("AnnotationPath").setUnderlyingType(new FullQualifiedName("Edm", "String"));
        }
        if ("PrimitiveType".equals(typeDefinitionName.getName())) {
            return new CsdlTypeDefinition().setName("PrimitiveType").setUnderlyingType(new FullQualifiedName("Edm", "String"));
        }
        return null;
    }

    public List<CsdlAliasInfo> getAliasInfos() throws ODataException {
        if (this.csdlAliasInfo == null) {
            ArrayList<CsdlAliasInfo> theCsdlAliasInfo = new ArrayList<CsdlAliasInfo>();
            List csdlSchemas = this.xmlMetadata.getSchemas();
            for (CsdlSchema csdlSchema : csdlSchemas) {
                theCsdlAliasInfo.add(new CsdlAliasInfo().setAlias(csdlSchema.getAlias()));
            }
            this.csdlAliasInfo = theCsdlAliasInfo;
        }
        return this.csdlAliasInfo;
    }

    public CsdlEnumType getEnumType(FullQualifiedName enumTypeName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!csdlSchema.getNamespace().equals(enumTypeName.getNamespace())) continue;
            return csdlSchema.getEnumType(enumTypeName.getName());
        }
        return null;
    }

    public CsdlSingleton getSingleton(FullQualifiedName entityContainer, String singletonName) throws ODataException {
        CsdlSingleton csdlSingleton = null;
        String fqnContainer = null;
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (csdlSchema.getEntityContainer() == null || !(fqnContainer = csdlSchema.getNamespace() + "." + (csdlSchema.getEntityContainer() != null ? csdlSchema.getEntityContainer().getName() : "")).equals(entityContainer.getFullQualifiedNameAsString())) continue;
            csdlSingleton = csdlSchema.getEntityContainer().getSingleton(singletonName);
            break;
        }
        return csdlSingleton;
    }

    public CsdlTerm getTerm(FullQualifiedName termName) throws ODataException {
        List csdlSchemas = this.xmlMetadata.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!csdlSchema.getNamespace().equals(termName.getNamespace())) continue;
            return csdlSchema.getTerm(termName.getName());
        }
        CsdlTerm csdlTerm = new CsdlTerm();
        csdlTerm.setName(termName.getName());
        csdlTerm.setType(termName.getFullQualifiedNameAsString());
        return csdlTerm;
    }
}

