/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors.response;

import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.adapter.odata.v4.utils.StreamUtils;
import com.sap.cds.adapter.odata.v4.utils.TypeConverterUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ETagUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetProcessor {
    static final Logger logger = LoggerFactory.getLogger(ResultSetProcessor.class);
    private final CdsRequestGlobals globals;
    private final EdmxFlavourMapper toEdmxMapper;
    private final EdmxFlavourMapper toCsnMapper;
    private final EdmUtils edmUtils;

    public ResultSetProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.toEdmxMapper = EdmxFlavourMapper.create(globals.getEdmxFlavour(), false);
        this.toCsnMapper = EdmxFlavourMapper.create(globals.getEdmxFlavour(), true);
        this.edmUtils = new EdmUtils(globals);
    }

    public Entity toEntity(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        if (!result.first().isPresent()) {
            return null;
        }
        EdmEntityType type = this.checkEntityType(request.getResponseType());
        EdmBindingTarget bindingTarget = this.edmUtils.getEdmBindingTarget(type);
        String eTagProperty = this.getETagProperty(type);
        return this.toEntity(bindingTarget, type, eTagProperty, (Map<?, ?>)result.single(), request, expand);
    }

    public EntityCollection toEntityCollection(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        EdmEntityType type = this.checkEntityType(request.getResponseType());
        EdmBindingTarget bindingTarget = this.edmUtils.getEdmBindingTarget(type);
        EntityCollection entitySet = new EntityCollection();
        this.toEntities(bindingTarget, type, result.list(), request, expand, entitySet.getEntities()::add);
        return entitySet;
    }

    private void toEntities(EdmBindingTarget bindingTarget, EdmEntityType type, List<?> result, CdsODataRequest request, ExpandTreeBuilder expand, Consumer<Entity> consumer) {
        String eTagProperty = this.getETagProperty(type);
        result.stream().map(row -> this.toEntity(bindingTarget, type, eTagProperty, (Map)row, request, expand)).forEach(consumer);
    }

    private Entity toEntity(EdmBindingTarget bindingTarget, EdmEntityType type, String eTagProperty, Map<?, ?> entityRow, CdsODataRequest request, ExpandTreeBuilder expand) {
        Entity entity = new Entity();
        entity.setType(type.getFullQualifiedName().getFullQualifiedNameAsString());
        HashMap applyProperties = null;
        if (request.hasApply()) {
            applyProperties = new HashMap(entityRow);
        }
        if (bindingTarget != null) {
            try {
                entity.setId(new URI(bindingTarget.getName() + ResultSetProcessor.getEntityId(type, entityRow)));
            }
            catch (URISyntaxException e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
            }
        }
        List propertyNames = type.getPropertyNames();
        for (String propertyName : propertyNames) {
            Property property;
            EdmProperty edmProperty = (EdmProperty)type.getProperty(propertyName);
            Object value2 = entityRow.get(propertyName);
            if (value2 == null && !entityRow.containsKey(propertyName) && edmProperty.getType() != EdmStream.getInstance()) continue;
            if (applyProperties != null) {
                applyProperties.remove(propertyName);
            }
            if ((property = this.consumeProperty(edmProperty, value2, request, expand)).getType().equals("Edm.Stream")) {
                boolean isV40 = ODataServiceVersion.V40.toString().equals(ODataUtils.getODataVersion(request.getODataRequest()));
                boolean exists = property.getValue() != null;
                property.setValue(property.getValueType(), null);
                Annotation mediaContentType = new Annotation();
                mediaContentType.setTerm((isV40 ? "odata." : "") + "mediaContentType");
                mediaContentType.setType("String");
                mediaContentType.setValue(ValueType.PRIMITIVE, exists ? this.getContentType(type, propertyName, entityRow) : null);
                property.getAnnotations().add(mediaContentType);
            }
            entity.addProperty(property);
            if (!Objects.equals(propertyName, eTagProperty) || property.getValue() == null) continue;
            String etag = ETagUtils.createETagHeaderValue((String)property.getValue().toString());
            entity.setETag(etag);
        }
        List navigationPropertyNames = type.getNavigationPropertyNames();
        for (String navigationPropertyName : navigationPropertyNames) {
            Link link;
            Object navigationValue;
            if (applyProperties != null) {
                applyProperties.remove(navigationPropertyName);
            }
            if ((navigationValue = entityRow.get(navigationPropertyName)) != null) {
                EdmNavigationProperty navigationProperty = type.getNavigationProperty(navigationPropertyName);
                link = this.createLink(navigationProperty, navigationValue, request, expand);
            } else {
                link = new Link();
                link.setTitle(navigationPropertyName);
            }
            if (entity.getId() != null) {
                link.setHref(entity.getId().toASCIIString() + "/" + navigationPropertyName);
            }
            entity.getNavigationLinks().add(link);
        }
        if (applyProperties != null) {
            applyProperties.forEach((key, value) -> {
                Property property = new Property();
                property.setName(key.toString());
                property.setValue(ValueType.PRIMITIVE, value);
                entity.getProperties().add(property);
            });
        }
        return entity;
    }

    private String getETagProperty(EdmEntityType edmEntityType) {
        String eTagElement;
        String edmEntityName = edmEntityType.getFullQualifiedName().getFullQualifiedNameAsString();
        String cdsEntityName = this.globals.getCdsEntityNames().getOrDefault(edmEntityName, edmEntityName);
        Optional cdsEntity = this.globals.getModel().findEntity(cdsEntityName);
        if (cdsEntity.isPresent() && (eTagElement = ETagHelper.getETagElementName((CdsEntity)cdsEntity.get())) != null) {
            return this.toEdmxMapper.remap(eTagElement, (CdsStructuredType)cdsEntity.get());
        }
        return null;
    }

    private String getContentType(EdmEntityType edmEntityType, String edmStreamProperty, Map<?, ?> entityRow) {
        String edmEntityName = edmEntityType.getFullQualifiedName().getFullQualifiedNameAsString();
        String cdsEntityName = this.globals.getCdsEntityNames().getOrDefault(edmEntityName, edmEntityName);
        CdsEntity cdsEntity = this.globals.getModel().findEntity(cdsEntityName).orElse(null);
        if (cdsEntity != null) {
            String cdsStreamProperty = this.toCsnMapper.remap(edmStreamProperty, (CdsStructuredType)cdsEntity);
            String mediaTypeElement = StreamUtils.getCoreMediaTypeElement(cdsEntity, cdsStreamProperty);
            if (!StringUtils.isEmpty((CharSequence)mediaTypeElement)) {
                return (String)entityRow.get(this.toEdmxMapper.remap(mediaTypeElement, (CdsStructuredType)cdsEntity));
            }
            return StreamUtils.getCoreMediaTypeValue(cdsEntity, cdsStreamProperty);
        }
        return null;
    }

    public static String getEntityId(EdmEntityType type, Map<?, ?> row) {
        StringBuilder result = new StringBuilder();
        List keyNames = type.getKeyPredicateNames();
        boolean first = true;
        for (String keyName : keyNames) {
            EdmType propertyType;
            EdmKeyPropertyRef keyRef = type.getKeyPropertyRef(keyName);
            if (first) {
                result.append('(');
                first = false;
            } else {
                result.append(',');
            }
            if (keyNames.size() > 1) {
                result.append(Encoder.encode((String)keyName)).append('=');
            }
            String keyValue = (propertyType = keyRef.getProperty().getType()) instanceof EdmString || propertyType instanceof EdmDateTimeOffset || propertyType instanceof EdmTimeOfDay || propertyType instanceof AbstractGeospatialType ? Encoder.encode((String)String.valueOf(row.get(keyName))) : String.valueOf(row.get(keyName));
            if (propertyType instanceof EdmString) {
                result.append("'").append(keyValue).append("'");
                continue;
            }
            result.append(keyValue);
        }
        if (result.length() > 0) {
            result.append(')');
        }
        return result.toString();
    }

    private Property consumeProperty(EdmProperty edmProperty, Object propertyValue, CdsODataRequest request, ExpandTreeBuilder expand) {
        return this.consumeProperty(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), propertyValue, request, expand);
    }

    private Property consumeProperty(String propertyName, EdmType propertyType, boolean isCollection, Object propertyValue, CdsODataRequest request, ExpandTreeBuilder expand) {
        List convertedValue;
        Property property = new Property();
        property.setName(propertyName);
        property.setType(propertyType.getFullQualifiedName().getFullQualifiedNameAsString());
        property.setValue(switch (propertyType.getKind()) {
            case EdmTypeKind.PRIMITIVE, EdmTypeKind.DEFINITION, EdmTypeKind.ENUM -> {
                if (isCollection) {
                    Stream<Object> stream = propertyValue instanceof List ? ((List)propertyValue).stream() : Stream.of(propertyValue);
                    convertedValue = stream.map(v -> TypeConverterUtils.getValueBasedOnTypeOfResultSet(propertyType, v)).collect(Collectors.toList());
                    yield propertyType.getKind() == EdmTypeKind.ENUM ? ValueType.COLLECTION_ENUM : ValueType.COLLECTION_PRIMITIVE;
                }
                convertedValue = TypeConverterUtils.getValueBasedOnTypeOfResultSet(propertyType, propertyValue);
                yield propertyType.getKind() == EdmTypeKind.ENUM ? ValueType.ENUM : ValueType.PRIMITIVE;
            }
            case EdmTypeKind.COMPLEX -> {
                if (isCollection) {
                    Stream<Object> stream = propertyValue instanceof List ? ((List)propertyValue).stream() : Stream.of(propertyValue);
                    convertedValue = stream.map(v -> this.consumeComplexValue((EdmComplexType)propertyType, v, request, expand)).collect(Collectors.toList());
                    yield ValueType.COLLECTION_COMPLEX;
                }
                convertedValue = this.consumeComplexValue((EdmComplexType)propertyType, propertyValue, request, expand);
                yield ValueType.COMPLEX;
            }
            default -> throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{propertyType.getKind()});
        }, convertedValue);
        return property;
    }

    private Link createLink(EdmNavigationProperty navigationProperty, Object navigationValue, CdsODataRequest request, ExpandTreeBuilder expand) {
        Link link = new Link();
        link.setTitle(navigationProperty.getName());
        ExpandTreeBuilder childExpand = expand != null ? expand.expand(navigationProperty) : null;
        EdmEntityType edmEntityType = navigationProperty.getType();
        EdmBindingTarget bindingTarget = this.edmUtils.getEdmBindingTarget(edmEntityType);
        if (navigationProperty.isCollection()) {
            List<Object> navigationValueList = navigationValue instanceof List ? (List<Object>)navigationValue : Arrays.asList(navigationValue);
            EntityCollection inlineEntitySet = new EntityCollection();
            this.toEntities(bindingTarget, edmEntityType, navigationValueList, request, childExpand, inlineEntitySet.getEntities()::add);
            link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
            link.setInlineEntitySet(inlineEntitySet);
        } else {
            String eTagProperty = this.getETagProperty(edmEntityType);
            Entity inlineEntity = this.toEntity(bindingTarget, edmEntityType, eTagProperty, (Map)navigationValue, request, childExpand);
            link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
            link.setInlineEntity(inlineEntity);
        }
        return link;
    }

    private ComplexValue consumeComplexValue(EdmComplexType type, Object value, CdsODataRequest request, ExpandTreeBuilder expand) {
        ComplexValue complexValue = new ComplexValue();
        complexValue.setTypeName(type.getFullQualifiedName().getFullQualifiedNameAsString());
        Map valueMap = (Map)value;
        for (String propertyName : type.getPropertyNames()) {
            Object propertyValue = valueMap.get(propertyName);
            if (propertyValue == null) continue;
            EdmProperty edmProperty = (EdmProperty)type.getProperty(propertyName);
            Property property = this.consumeProperty(edmProperty, propertyValue, request, expand);
            complexValue.getValue().add(property);
        }
        for (String navigationPropertyName : type.getNavigationPropertyNames()) {
            Object navigationValue = valueMap.get(navigationPropertyName);
            if (navigationValue == null) continue;
            EdmNavigationProperty navigationProperty = type.getNavigationProperty(navigationPropertyName);
            Link link = this.createLink(navigationProperty, navigationValue, request, expand);
            complexValue.getNavigationLinks().add(link);
        }
        return complexValue;
    }

    private EdmEntityType checkEntityType(EdmType type) {
        if (type.getKind() != EdmTypeKind.ENTITY) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{type.getKind()});
        }
        return (EdmEntityType)type;
    }

    public Property toComplex(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        EdmComplexType type = this.checkComplexType(request.getResponseType());
        String name = this.retrieveComplexName((UriResource)request.getLastTypedResource());
        return this.consumeProperty(name, (EdmType)type, false, result.single(), request, expand);
    }

    public Property toComplexCollection(CdsODataRequest request, Result result, ExpandTreeBuilder expand) {
        List results;
        EdmComplexType type = this.checkComplexType(request.getResponseType());
        UriResourcePartTyped resource = request.getLastTypedResource();
        String name = this.retrieveComplexName((UriResource)resource);
        if (resource.getKind().equals((Object)UriResourceKind.complexProperty)) {
            Row row = result.single();
            results = (List)row.get((Object)name);
        } else {
            results = result.list();
        }
        return this.consumeProperty(name, (EdmType)type, true, results, request, expand);
    }

    private EdmComplexType checkComplexType(EdmType type) {
        if (type.getKind() != EdmTypeKind.COMPLEX) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{type.getKind()});
        }
        return (EdmComplexType)type;
    }

    private String retrieveComplexName(UriResource resource) {
        return switch (resource.getKind()) {
            case UriResourceKind.complexProperty -> ((UriResourceComplexProperty)resource).getProperty().getName();
            case UriResourceKind.action -> ((UriResourceAction)resource).getAction().getName();
            case UriResourceKind.function -> ((UriResourceFunction)resource).getFunction().getName();
            default -> throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
        };
    }

    public Property toPrimitive(CdsODataRequest request, Result result) {
        EdmPrimitiveType type = this.checkPrimitiveType(request.getResponseType());
        String name = this.retrievePrimitiveName((UriResource)request.getLastTypedResource());
        Object primitive = result.single().get((Object)name);
        return this.consumeProperty(name, (EdmType)type, false, primitive, request, null);
    }

    public Property toPrimitiveCollection(CdsODataRequest request, Result result) {
        EdmPrimitiveType type = this.checkPrimitiveType(request.getResponseType());
        String name = this.retrievePrimitiveName((UriResource)request.getLastTypedResource());
        Object primitive = result.single().get((Object)name);
        return this.consumeProperty(name, (EdmType)type, true, primitive, request, null);
    }

    private EdmPrimitiveType checkPrimitiveType(EdmType type) {
        if (type.getKind() != EdmTypeKind.PRIMITIVE) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{type.getKind()});
        }
        return (EdmPrimitiveType)type;
    }

    private String retrievePrimitiveName(UriResource resource) {
        return switch (resource.getKind()) {
            case UriResourceKind.primitiveProperty -> ((UriResourcePrimitiveProperty)resource).getProperty().getName();
            case UriResourceKind.action -> ((UriResourceAction)resource).getAction().getName();
            case UriResourceKind.function -> ((UriResourceFunction)resource).getFunction().getName();
            default -> throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
        };
    }

    public static int toCount(Result result) {
        int count = 0;
        for (Map row : result.list()) {
            count += Integer.parseInt(row.get("count").toString());
        }
        return count;
    }
}

