/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.adapter.odata.v4.query.apply.ElementAggregator;
import com.sap.cds.adapter.odata.v4.utils.TypeConverterUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

public class ExpressionParser {
    private final CdsStructuredType rootType;
    private final EdmxFlavourMapper elementMapper;

    public ExpressionParser(CdsStructuredType rootType, EdmxFlavourMapper elementMapper) {
        this.rootType = rootType;
        this.elementMapper = elementMapper;
    }

    public Value<?> parseValue(Expression expression) {
        try {
            return (Value)expression.accept((ExpressionVisitor)new ExpressionToCqnVisitor());
        }
        catch (ODataApplicationException | ExpressionVisitException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_PARSING_FAILED, new Object[]{e});
        }
    }

    public Predicate parseFilter(Expression expression) {
        try {
            return (Predicate)expression.accept((ExpressionVisitor)new ExpressionToCqnVisitor());
        }
        catch (ODataApplicationException | ExpressionVisitException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FILTER_PARSING_FAILED, new Object[]{e});
        }
    }

    public List<CqnReference.Segment> toSegmentList(List<UriResource> uriResourceParts) {
        ArrayList<CqnReference.Segment> segmentList = new ArrayList<CqnReference.Segment>();
        CdsStructuredType type = this.rootType;
        for (UriResource part : uriResourceParts) {
            if (part.getKind() == UriResourceKind.lambdaVariable) continue;
            if (type == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{part.getKind()});
            }
            String segment = this.elementMapper.remap(part.getSegmentValue(), type);
            type = ExpressionParser.structuredType(type.findElement(segment).orElse(null));
            for (String id : segment.split("\\.")) {
                segmentList.add(CQL.refSegment((String)id));
            }
        }
        return segmentList;
    }

    public String remap(String element) {
        return this.elementMapper.remap(element, this.rootType);
    }

    private static CdsStructuredType structuredType(CdsElement element) {
        if (element != null) {
            CdsType type = element.getType();
            if (type.isStructured()) {
                return (CdsStructuredType)type.as(CdsStructuredType.class);
            }
            if (type.isAssociation()) {
                return ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget();
            }
        }
        return null;
    }

    public CdsStructuredType getRootType() {
        return this.rootType;
    }

    @VisibleForTesting
    class ExpressionToCqnVisitor
    implements ExpressionVisitor<Object> {
        ExpressionToCqnVisitor() {
        }

        public Object visitBinaryOperator(BinaryOperatorKind operator, Object left, Object right) {
            switch (operator) {
                case AND: {
                    return ((Predicate)left).and((CqnPredicate)((Predicate)right), new CqnPredicate[0]);
                }
                case OR: {
                    return ((Predicate)left).or((CqnPredicate)((Predicate)right), new CqnPredicate[0]);
                }
                case EQ: {
                    if (left instanceof Predicate && right instanceof Predicate) {
                        Predicate lhs = (Predicate)left;
                        Predicate rhs = (Predicate)right;
                        Predicate bothTrue = lhs.and((CqnPredicate)rhs, new CqnPredicate[0]);
                        Predicate bothFalse = lhs.not().and((CqnPredicate)rhs.not(), new CqnPredicate[0]);
                        return bothTrue.or((CqnPredicate)bothFalse, new CqnPredicate[0]);
                    }
                    return ((Value)left).is((Value)right);
                }
                case NE: {
                    if (left instanceof Predicate && right instanceof Predicate) {
                        Predicate lhs = (Predicate)left;
                        Predicate rhs = (Predicate)right;
                        Predicate eitherTrue = lhs.or((CqnPredicate)rhs, new CqnPredicate[0]);
                        Predicate eitherFalse = lhs.not().or((CqnPredicate)rhs.not(), new CqnPredicate[0]);
                        return eitherTrue.and((CqnPredicate)eitherFalse, new CqnPredicate[0]);
                    }
                    return ((Value)left).isNot((Value)right);
                }
                case GE: {
                    return ((Value)left).ge((Value)right);
                }
                case GT: {
                    return ((Value)left).gt((Value)right);
                }
                case LE: {
                    return ((Value)left).le((Value)right);
                }
                case LT: {
                    return ((Value)left).lt((Value)right);
                }
                case ADD: {
                    return ((Value)left).plus((Value)right);
                }
                case SUB: {
                    return ((Value)left).minus((Value)right);
                }
                case MUL: {
                    return ((Value)left).times((Value)right);
                }
                case DIV: {
                    return ((Value)left).dividedBy((Value)right);
                }
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_OPERATOR, new Object[]{operator});
        }

        public Object visitUnaryOperator(UnaryOperatorKind operator, Object operand) {
            switch (operator) {
                case NOT: {
                    return ((Predicate)operand).not();
                }
            }
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }

        public Object visitMethodCall(MethodKind methodCall, List<Object> parameters) {
            String func;
            Value value = (Value)parameters.get(0);
            switch (func = methodCall.name().toUpperCase(Locale.US)) {
                case "TOUPPER": {
                    return value.toUpper();
                }
                case "TOLOWER": {
                    return value.toLower();
                }
                case "LENGTH": 
                case "TRIM": {
                    return CQL.func((String)methodCall.name(), (CqnValue[])new CqnValue[]{value});
                }
                case "SUBSTRING": {
                    Value start = null;
                    if (parameters.size() >= 2) {
                        start = (Value)parameters.get(1);
                    }
                    switch (parameters.size()) {
                        case 2: {
                            return value.substring(start);
                        }
                        case 3: {
                            Value length = (Value)parameters.get(2);
                            return value.substring(start, length);
                        }
                    }
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_SUBSTRING, new Object[0]);
                }
                case "CONTAINS": {
                    Value substring = (Value)parameters.get(1);
                    return value.contains(substring);
                }
                case "STARTSWITH": {
                    Value prefix = (Value)parameters.get(1);
                    return value.startsWith(prefix);
                }
                case "ENDSWITH": {
                    Value suffix = (Value)parameters.get(1);
                    return value.endsWith(suffix);
                }
                case "COMPUTE_AGGREGATE": {
                    return value;
                }
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_METHOD, new Object[]{func});
        }

        public Object visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }

        public Value<?> visitLiteral(Literal literal) {
            if (literal.getText() == null || literal.getType() == null) {
                return CqnNull.getInstance();
            }
            Object literalValue = TypeConverterUtils.convertToType(literal.getType(), literal.getText());
            return CQL.val((Object)literalValue);
        }

        public CqnValue visitMember(Member member) throws ExpressionVisitException, ODataApplicationException {
            List uriResourceParts = member.getResourcePath().getUriResourceParts();
            UriResource lastPart = (UriResource)uriResourceParts.get(uriResourceParts.size() - 1);
            if (lastPart.getKind() == UriResourceKind.lambdaAny) {
                StructuredType ref = CQL.to(ExpressionParser.this.toSegmentList(uriResourceParts.subList(0, uriResourceParts.size() - 1)));
                UriResourceLambdaAny lambdaAny = (UriResourceLambdaAny)lastPart;
                if (lambdaAny.getExpression() != null) {
                    CdsStructuredType target = CdsModelUtils.target((CdsStructuredType)ExpressionParser.this.rootType, (List)ref.asRef().segments());
                    CqnPredicate pred = (CqnPredicate)lambdaAny.getExpression().accept((ExpressionVisitor)new ExpressionParser(target, ExpressionParser.this.elementMapper).new ExpressionToCqnVisitor());
                    return ref.anyMatch(pred);
                }
                return ref.exists();
            }
            if (lastPart.getKind() == UriResourceKind.lambdaAll) {
                StructuredType ref = CQL.to(ExpressionParser.this.toSegmentList(uriResourceParts.subList(0, uriResourceParts.size() - 1)));
                UriResourceLambdaAll lambdaAll = (UriResourceLambdaAll)lastPart;
                CdsStructuredType target = CdsModelUtils.target((CdsStructuredType)ExpressionParser.this.rootType, (List)ref.asRef().segments());
                Predicate pred = (Predicate)lambdaAll.getExpression().accept((ExpressionVisitor)new ExpressionParser(target, ExpressionParser.this.elementMapper).new ExpressionToCqnVisitor());
                return ref.allMatch((CqnPredicate)pred);
            }
            return CQL.get(ExpressionParser.this.toSegmentList(uriResourceParts));
        }

        public Object visitAlias(String aliasName) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }

        public Object visitTypeLiteral(EdmType type) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }

        public Object visitLambdaReference(String variableName) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }

        public Object visitEnum(EdmEnumType type, List enumValues) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }

        public Predicate visitBinaryOperator(BinaryOperatorKind operator, Object left, List<Object> right) {
            if (operator == BinaryOperatorKind.IN) {
                Value[] items = right.toArray(new Value[right.size()]);
                return ((Value)left).in(items);
            }
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }

        public CqnValue visitComputeAggregate(AggregateExpression.StandardMethod standardMethod, UriInfo path, Object expression) throws ExpressionVisitException, ODataApplicationException {
            Value<?> func;
            ElementAggregator aggregator = new ElementAggregator(ExpressionParser.this);
            if (standardMethod != null) {
                func = aggregator.toFunctionCall((Value)expression, standardMethod);
            } else {
                List uriResourceParts = path.asUriInfoResource().getUriResourceParts();
                ElementRef ref = CQL.get(ExpressionParser.this.toSegmentList(uriResourceParts));
                func = aggregator.customAggregate((ElementRef<Object>)ref);
            }
            return func;
        }
    }
}

