/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.ApplyHandler;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;

public class GroupByTransformation
implements Transformation {
    private final GroupBy gBy;
    private final ExpressionParser expressionParser;

    public GroupByTransformation(GroupBy gBy, ExpressionParser expressionParser) {
        this.gBy = gBy;
        this.expressionParser = expressionParser;
    }

    @Override
    public Select<?> apply(Select<?> select) {
        List gByItems = this.gBy.getGroupByItems();
        ArrayList<ElementRef> dimensions = new ArrayList<ElementRef>(gByItems.size());
        for (GroupByItem gByItem : gByItems) {
            ElementRef ref = CQL.get(this.expressionParser.toSegmentList(gByItem.getPath()));
            dimensions.add(ref);
        }
        select.groupBy(dimensions);
        ArrayList selectItems = new ArrayList();
        if (this.gBy.getApplyOption() != null) {
            ApplyOption gByApplyOption = this.gBy.getApplyOption();
            ApplyHandler applyHandler = new ApplyHandler(gByApplyOption, this.expressionParser);
            List<Transformation> transformations = applyHandler.getTransformations();
            for (Transformation transformation : transformations) {
                select = (Select)transformation.apply(select);
            }
            selectItems.addAll(select.items());
        }
        dimensions.stream().map(r -> r.as(r.path())).forEach(selectItems::add);
        select.columns(selectItems);
        return select;
    }

    @Override
    public int rank() {
        return 2;
    }
}

