/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.options;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import org.apache.olingo.commons.api.IConstants;
import org.apache.olingo.commons.api.constants.Constantsv00;
import org.apache.olingo.commons.api.constants.Constantsv01;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;

public abstract class CdsODataOptions {
    protected ContextURL contextURL;
    private boolean isODataMetadataNone;
    private boolean isODataMetadataFull;
    private final String odataVersion;
    private final CdsRequestGlobals globals;
    private final EdmUtils edmUtils;
    private final IConstants constants;
    private final boolean isIEEE754Compatible;

    public CdsODataOptions(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
        this.odataVersion = odataVersion;
        this.globals = globals;
        this.edmUtils = new EdmUtils(globals);
        this.constants = CdsODataOptions.constants(odataVersion);
        if (contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            String odataMetadata = contentType.getParameter("odata.metadata");
            if (odataMetadata != null) {
                if ("none".equalsIgnoreCase(odataMetadata)) {
                    this.isODataMetadataNone = true;
                } else if ("full".equalsIgnoreCase(odataMetadata)) {
                    this.isODataMetadataFull = true;
                } else if (!"minimal".equalsIgnoreCase(odataMetadata)) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_PARAMETER_VALUE, new Object[]{odataMetadata, "odata.metadata"});
                }
            }
        } else {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_CONTENT_TYPE, new Object[]{contentType.toContentTypeString()});
        }
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible((ContentType)contentType);
    }

    private static IConstants constants(String odataVersion) {
        Constantsv00 c = new Constantsv00();
        if (odataVersion != null && Float.valueOf(odataVersion).floatValue() > 4.0f) {
            c = new Constantsv01();
        }
        return c;
    }

    public boolean isODataMetadataNone() {
        return this.isODataMetadataNone;
    }

    public boolean isODataMetadataFull() {
        return this.isODataMetadataFull;
    }

    public IConstants getConstants() {
        return this.constants;
    }

    public EdmUtils getEdmUtils() {
        return this.edmUtils;
    }

    public String getODataVersion() {
        return this.odataVersion;
    }

    public CdsRequestGlobals getGlobals() {
        return this.globals;
    }

    public boolean isIEEE754Compatible() {
        return this.isIEEE754Compatible;
    }

    public ContextURL getContextURL() {
        return this.contextURL;
    }
}

