/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils.mapper;

import com.google.common.collect.Streams;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class V4EdmxFlavourMapper
implements EdmxFlavourMapper {
    private final boolean toCsn;

    public V4EdmxFlavourMapper(boolean toCsn) {
        this.toCsn = toCsn;
    }

    @Override
    public String remap(String element, CdsStructuredType type) {
        return this.buildMapping(type, true).filter(m -> this.toCsn ? m.getEdmxName().equals(element) : m.getCsnName().equals(element)).map(m -> this.toCsn ? m.getCsnName() : m.getEdmxName()).findAny().orElse(element);
    }

    @Override
    public <T extends Iterable<? extends Map<String, Object>>> T remap(T entries, CdsStructuredType entryType, final Function<String, Boolean> isExpanded) {
        DataProcessor.create().withDepthFirst().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> data) {
                V4EdmxFlavourMapper.this.remap(path, element, type, data, isExpanded);
            }
        }).process(entries, entryType);
        return entries;
    }

    private void remap(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> data, Function<String, Boolean> isExpanded) {
        boolean insideArray = Streams.concat((Stream[])new Stream[]{Streams.stream((Iterator)path.iterator()).map(p -> p.element()), Stream.of(element)}).filter(Objects::nonNull).anyMatch(e -> e.getType().isArrayed());
        boolean entityRoot = (path.iterator().hasNext() ? path.root().type() : type) instanceof CdsEntity;
        List<Mapping> mappings = this.buildMapping(type, !insideArray && entityRoot).sorted((m1, m2) -> Boolean.compare(m1.isForeignKey, m2.isForeignKey)).collect(Collectors.toList());
        for (Map<String, Object> map : data) {
            for (Mapping mapping : mappings) {
                if (this.toCsn) {
                    if (!map.containsKey(mapping.getEdmxName())) continue;
                    Object value = map.remove(mapping.getEdmxName());
                    if (DataUtils.containsKey(map, (String)mapping.getCsnName(), (boolean)true)) continue;
                    DataUtils.putPath(map, (String)mapping.getCsnName(), (Object)value);
                    continue;
                }
                String nextLevelCsnName = mapping.element.getName() + "." + mapping.innerMapping.getEdmxName();
                if (!DataUtils.containsKey(map, (String)nextLevelCsnName)) continue;
                Object value = DataUtils.getOrDefault(map, (String)nextLevelCsnName, null);
                boolean expanded = isExpanded.apply(this.join(path, element, mapping.element));
                if (!mapping.isForeignKey || !expanded && this.containsOnlyFKs(mapping, mappings, map)) {
                    this.removeDeep(map, nextLevelCsnName);
                }
                map.put(mapping.getEdmxName(), value);
            }
        }
    }

    private Stream<Mapping> buildMapping(CdsStructuredType type, boolean flattenStructs) {
        return this.buildMapping(type, flattenStructs, false, false).filter(m -> !Objects.equals(m.getEdmxName(), m.getCsnName()));
    }

    private Stream<Mapping> buildMapping(CdsStructuredType type, boolean flattenStructs, boolean isForeignKey, boolean insideStruct) {
        return type.elements().flatMap(e -> this.buildMapping((CdsElement)e, flattenStructs, isForeignKey, insideStruct));
    }

    private Stream<Mapping> buildMapping(CdsElement element, boolean flattenStructs, boolean isForeignKey, boolean insideStruct) {
        CdsType type = element.getType();
        if (type.isStructured()) {
            return this.buildMapping((CdsStructuredType)type.as(CdsStructuredType.class), flattenStructs, isForeignKey, true).map(i -> new Mapping(element, false, (Mapping)i));
        }
        if (type.isAssociation()) {
            Stream<Mapping> mappings = AssociationAnalyzer.refElements((CdsElement)element).flatMap(k -> this.buildMapping((CdsElement)k, flattenStructs, true, false)).map(i -> new Mapping(element, true, (Mapping)i));
            if (flattenStructs && insideStruct) {
                return Stream.concat(Stream.of(new Mapping(element, false)), mappings);
            }
            return mappings;
        }
        if (flattenStructs || isForeignKey) {
            return Stream.of(new Mapping(element, isForeignKey));
        }
        return Stream.empty();
    }

    private String join(Path path, CdsElement parent, CdsElement element) {
        ArrayList<String> segments = new ArrayList<String>();
        path.iterator().forEachRemaining(s -> {
            if (s.element() != null) {
                segments.add(s.segment().id());
            }
        });
        if (parent != null) {
            segments.add(parent.getName());
        }
        segments.add(element.getName());
        return String.join((CharSequence)".", segments);
    }

    private boolean containsOnlyFKs(Mapping current, List<Mapping> others, Map<String, Object> map) {
        Object assoc;
        if (current.isForeignKey && current.element.getType().isAssociation() && (assoc = map.get(current.element.getName())) instanceof Map) {
            List fks = others.stream().filter(o -> o.element.getName().equals(current.element.getName())).map(o -> o.innerMapping.getEdmxName()).collect(Collectors.toList());
            return fks.containsAll(((Map)assoc).keySet());
        }
        return false;
    }

    private void removeDeep(Map<String, Object> data, String path) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot > 0) {
            String start = path.substring(0, lastDot);
            String end = path.substring(lastDot + 1);
            Map last = (Map)DataUtils.getOrDefault(data, (String)start, null);
            if (last != null) {
                last.remove(end);
                if (last.isEmpty()) {
                    this.removeDeep(data, start);
                }
            }
        } else {
            data.remove(path);
        }
    }

    private class Mapping {
        private final CdsElement element;
        private final boolean isForeignKey;
        private final Mapping innerMapping;

        public Mapping(CdsElement element, boolean isForeignKey) {
            this(element, isForeignKey, null);
        }

        public Mapping(CdsElement element, boolean isForeignKey, Mapping innerMapping) {
            this.element = element;
            this.isForeignKey = isForeignKey;
            this.innerMapping = innerMapping;
        }

        public String getEdmxName() {
            return this.innerMapping == null ? this.element.getName() : this.element.getName() + "_" + this.innerMapping.getEdmxName();
        }

        public String getCsnName() {
            return this.innerMapping == null ? this.element.getName() : this.element.getName() + "." + this.innerMapping.getCsnName();
        }
    }
}

