/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.UrlEscapers;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.metadata.CustomMetadataProcessor;
import com.sap.cds.adapter.odata.v4.metadata.CustomServiceDocumentProcessor;
import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.ODataEdmProvider;
import com.sap.cds.adapter.odata.v4.metadata.SimpleETagSupport;
import com.sap.cds.adapter.odata.v4.metadata.model.AbstractEdmxProviderAccessor;
import com.sap.cds.adapter.odata.v4.processors.OlingoProcessor;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.adapter.odata.v4.utils.QueryLimitUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.path.CdsServicePath;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.api.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsODataV4Servlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(CdsODataV4Servlet.class);
    private static final String UNEXPECTED_ERROR_MESSAGE = "An unexpected error occurred during servlet processing";
    private final Map<String, ApplicationService> servicePaths;
    private final CdsRuntime runtime;

    public CdsODataV4Servlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.servicePaths = CdsServicePath.basePaths((CdsRuntime)runtime, (String)"odata-v4");
        AbstractEdmxProviderAccessor.initialize(runtime);
        QueryLimitUtils.initialize(runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ParameterInfo parameterInfo = this.runtime.getProvidedParameterInfo();
        Locale locale = parameterInfo.getLocale();
        AtomicBoolean unclosedChangeSetTracker = new AtomicBoolean(false);
        try {
            this.runtime.requestContext().parameters(parameterInfo).run(context -> {
                CdsRequestGlobals requestGlobals = new CdsRequestGlobals(this.runtime, context.getModel(), unclosedChangeSetTracker);
                String pathInfo = req.getPathInfo();
                if (pathInfo == null) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_URI_RESOURCE, new Object[0]);
                }
                MutablePair<ApplicationService, String> serviceInfo = this.extractServiceInfo(pathInfo);
                ApplicationService applicationService = (ApplicationService)serviceInfo.getLeft();
                this.fillCdsEntityNamesMap(requestGlobals, applicationService);
                String serviceName = applicationService.getDefinition().getQualifiedName();
                String servicePath = (String)serviceInfo.getRight();
                requestGlobals.setApplicationService(applicationService);
                MetadataInfo metadataInfo = AbstractEdmxProviderAccessor.getInstance().getMetadataInfo(serviceName);
                ODataEdmProvider edm = metadataInfo.getEdmxMetadataProvider();
                if (null == edm) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{serviceName});
                }
                OData odata = OData.newInstance();
                SimpleETagSupport etagSupport = new SimpleETagSupport(metadataInfo.getEtag());
                ServiceMetadata serviceMetadata = odata.createServiceMetadata((CsdlEdmProvider)edm, edm.getAllEDMXReference(), (ServiceMetadataETagSupport)etagSupport);
                requestGlobals.setOData(odata);
                requestGlobals.setServiceMetadata(serviceMetadata);
                ODataHttpHandler odataHandler = odata.createHandler(serviceMetadata);
                odataHandler.register((Processor)new OlingoProcessor(requestGlobals));
                odataHandler.register((Processor)new CustomServiceDocumentProcessor(this.runtime));
                odataHandler.register((Processor)new CustomMetadataProcessor(metadataInfo.getEdmxBytes()));
                req.setAttribute("requestMapping", (Object)CdsODataV4Servlet.determineRequestMapping(req, pathInfo, servicePath));
                odataHandler.process(req, resp);
            });
        }
        catch (ServiceException e) {
            int httpStatus = e.getErrorStatus().getHttpStatus();
            if (httpStatus >= 500 && httpStatus < 600) {
                logger.error(UNEXPECTED_ERROR_MESSAGE, (Throwable)e);
            } else {
                logger.debug(UNEXPECTED_ERROR_MESSAGE, (Throwable)e);
            }
            this.writeErrorResponse(req, resp, httpStatus, e.getLocalizedMessage(locale));
        }
        catch (Exception e) {
            logger.error(UNEXPECTED_ERROR_MESSAGE, (Throwable)e);
            this.writeErrorResponse(req, resp, 500, new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale));
        }
        finally {
            ChangeSetContext changeSetContext = ChangeSetContext.getCurrent();
            if (unclosedChangeSetTracker.get() && changeSetContext != null) {
                logger.warn("Closing a detected unclosed ChangeSet Context");
                try {
                    ((ChangeSetContextSPI)changeSetContext).close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    static String determineRequestMapping(HttpServletRequest req, String pathInfo, String servicePath) {
        String requestURL = req.getRequestURL().toString();
        String requestPath = req.getRequestURI();
        int serviceIndex = requestPath.indexOf(servicePath);
        if (serviceIndex >= 0 && requestPath.indexOf(servicePath, serviceIndex + 1) == -1) {
            return requestURL.substring(0, requestURL.length() - requestPath.length() + serviceIndex + servicePath.length());
        }
        String encodedPathInfo = UrlEscapers.urlPathSegmentEscaper().escape(pathInfo).replace("%2F", "/");
        String encodedServicePath = UrlEscapers.urlPathSegmentEscaper().escape(servicePath).replace("%2F", "/");
        return requestURL.substring(0, requestURL.length() - encodedPathInfo.length() + encodedPathInfo.indexOf(encodedServicePath) + encodedServicePath.length());
    }

    private void fillCdsEntityNamesMap(CdsRequestGlobals requestGlobals, ApplicationService applicationService) {
        applicationService.getDefinition().entities().forEach(entity -> {
            String cdsName = entity.getName();
            String edmName = com.sap.cds.services.utils.ODataUtils.toODataName((String)cdsName);
            if (!edmName.equals(cdsName)) {
                String key = entity.getQualifier() + "." + edmName;
                String value = entity.getQualifier() + "." + cdsName;
                requestGlobals.getCdsEntityNames().put(key, value);
            }
        });
    }

    private void writeErrorResponse(HttpServletRequest req, HttpServletResponse resp, int httpStatus, String message) throws IOException {
        String responseContent = "{\"error\":{\"code\":\"" + httpStatus + "\",\"message\":\"" + message + "\"}}";
        resp.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
        resp.setHeader("OData-Version", ODataUtils.getODataVersion(req.getHeader("OData-Version"), req.getHeader("OData-MaxVersion")));
        resp.setStatus(httpStatus);
        resp.getWriter().println(responseContent);
    }

    private MutablePair<ApplicationService, String> extractServiceInfo(String pathInfo) {
        String servicePath;
        ApplicationService service;
        if (pathInfo.trim().isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[0]);
        }
        String path = StringUtils.trim((String)pathInfo.trim(), (char)'/');
        Optional<String> servicePathKey = this.servicePaths.keySet().stream().sorted((a, b) -> -1 * Integer.compare(a.length(), b.length())).filter(p -> path.equals(p) || path.startsWith(p + "/")).findFirst();
        if (servicePathKey.isPresent() && (service = this.servicePaths.get(servicePath = servicePathKey.get())) != null) {
            return MutablePair.of((Object)service, (Object)servicePath);
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{path});
    }
}

