/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.model;

import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.ODataEdmProvider;
import com.sap.cds.adapter.odata.v4.metadata.model.AbstractEdmxProviderAccessor;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static final String V4 = "v4";
    private static Logger log = LoggerFactory.getLogger(DynamicEdmxProviderAccessor.class);
    private final MetaDataAccessor<MetadataInfo> accessor;
    private final CdsRuntime runtime;

    public DynamicEdmxProviderAccessor(CdsRuntime runtime) {
        this.runtime = runtime;
        this.accessor = new DynamicModelUtils(runtime).createMetadataAccessor((edmx, service) -> {
            ODataEdmProvider edmProvider;
            byte[] edmxBytes = edmx.getBytes(StandardCharsets.UTF_8);
            try {
                edmProvider = this.loadMetadataFiles(service, edmxBytes);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA_DYNAMIC, new Object[]{service, e});
            }
            String etag = this.calculateMetadataEtag(edmxBytes);
            return new MetadataInfo(edmxBytes, edmProvider, etag);
        }, null);
    }

    @Override
    public MetadataInfo getMetadataInfo(String serviceName) {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        Locale locale = requestContext.getParameterInfo().getLocale();
        String localeString = locale != null ? LocaleUtils.getLocaleForBundle((Locale)locale).toString() : Locale.ENGLISH.getLanguage();
        UserInfo userInfo = requestContext.getUserInfo();
        String tenant = userInfo.getTenant();
        Set features = requestContext.getFeatureTogglesInfo().getEnabledFeatureToggles().map(ft -> ft.getName()).collect(Collectors.toSet());
        ModelId modelId = ModelId.create((String)tenant).odata(serviceName, localeString, V4).features(features).build();
        int maxAgeSeconds = Integer.MAX_VALUE;
        log.debug("Retrieving model for service name '{}', locale '{}' and features {}", new Object[]{serviceName, localeString, features});
        try {
            return (MetadataInfo)this.accessor.getEdmx(modelId, maxAgeSeconds);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EDMX_READ_FAILED, new Object[]{serviceName, t});
        }
    }
}

