/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.utils.ElementUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ETagUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsTypeUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;

public class ETagHelper {
    public static boolean isETagHeaderInRequest(CdsODataRequest odataRequest) {
        return odataRequest.getHeader("If-Match") != null || odataRequest.getHeader("If-None-Match") != null;
    }

    public static boolean hasIfNoneMatchHeaderWithAsteriskValue(CdsODataRequest request) {
        List headerValueList = ETagUtils.parseHeader((String)request.getHeader("If-None-Match"));
        return headerValueList != null && headerValueList.contains("*");
    }

    public static boolean hasETag(CdsEntity entity) {
        return ETagHelper.getETagElement(entity).map(e -> (String)e.getKey()).isPresent();
    }

    public static String getETagElementName(CdsEntity entity) {
        return ETagHelper.getETagElement(entity).map(e -> (String)e.getKey()).orElse(null);
    }

    public static CqnPredicate getETagPredicate(CdsODataRequest request, CdsEntity entity) {
        List ifNoneMatchValues;
        Map.Entry<String, CdsElement> etagElement = ETagHelper.getETagElement(entity).orElseThrow(() -> new IllegalStateException("Entity must have an ETag"));
        Predicate predicate = null;
        List ifMatchValues = ETagUtils.parseHeader((String)request.getHeader("If-Match"));
        if (ifMatchValues != null && !ifMatchValues.contains("*")) {
            List convertedValues = ifMatchValues.stream().map(v -> ETagHelper.convertETag(v, (CdsElement)etagElement.getValue())).collect(Collectors.toList());
            predicate = CQL.get((String)etagElement.getKey()).in(convertedValues);
        }
        if ((ifNoneMatchValues = ETagUtils.parseHeader((String)request.getHeader("If-None-Match"))) != null) {
            ifNoneMatchValues.remove("*");
            if (!ifNoneMatchValues.isEmpty()) {
                List convertedValues = ifNoneMatchValues.stream().map(v -> ETagHelper.convertETag(v, (CdsElement)etagElement.getValue())).collect(Collectors.toList());
                Predicate predicateIfNone = CQL.not((CqnPredicate)CQL.get((String)etagElement.getKey()).in(convertedValues));
                if (predicate != null) {
                    predicate = CQL.and((CqnPredicate)predicate, (CqnPredicate)predicateIfNone);
                } else {
                    return predicateIfNone;
                }
            }
        }
        return predicate;
    }

    private static Optional<Map.Entry<String, CdsElement>> getETagElement(CdsEntity entity) {
        return ElementUtils.recursiveElements((CdsStructuredType)entity, e -> CdsAnnotations.ETAG.isTrue((CdsAnnotatable)e)).entrySet().stream().findFirst();
    }

    private static Object convertETag(String value, CdsElement element) {
        CdsBaseType type = ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType();
        try {
            return CdsTypeUtils.parse((CdsBaseType)type, (String)value);
        }
        catch (CdsDataException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_VALUE_INVALID, new Object[]{type.cdsName(), e});
        }
    }

    public static String getETagProperty(CdsRequestGlobals globals, EdmStructuredType entityType) {
        String eTagElement;
        String edmEntityName = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        String cdsEntityName = globals.getCdsEntityNames().getOrDefault(edmEntityName, edmEntityName);
        Optional cdsEntity = globals.getModel().findEntity(cdsEntityName);
        if (cdsEntity.isPresent() && (eTagElement = ETagHelper.getETagElementName((CdsEntity)cdsEntity.get())) != null) {
            return EdmxFlavourMapper.create(globals.getEdmxFlavour(), false).remap(eTagElement, (CdsStructuredType)cdsEntity.get());
        }
        return null;
    }

    public static String getEtagValue(CdsRequestGlobals globals, EdmEntityType entityType, Row row) {
        Object value;
        String eTagProperty = ETagHelper.getETagProperty(globals, (EdmStructuredType)entityType);
        if (null != eTagProperty && null != (value = row.get((Object)eTagProperty))) {
            return ETagUtils.createETagHeaderValue((String)value.toString());
        }
        return null;
    }
}

