/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.transformation.CqnAggregateTransformation;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class AggregateTransformation implements CqnAggregateTransformation {

	private final List<CqnSelectListValue> items;

	public AggregateTransformation(Aggregate agg, ExpressionParser expressionParser) {
		ElementAggregator aggregator = new ElementAggregator(expressionParser);
		items = new ArrayList<CqnSelectListValue>();
		List<AggregateExpression> agExps = agg.getExpressions();
		for (AggregateExpression agExp : agExps) {
			if (agExp.getInlineAggregateExpression() != null) {
				throw new ErrorStatusException(CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, agExp.getPath().toArray());
			}
			Value<?> func;
			String alias;
			if (agExp.getExpression() != null) {
				// Simple aggregation queries like aggregate(price with sum as Total)
				func = aggregator.genericAggregate(agExp.getExpression(), agExp.getStandardMethod());
				alias = agExp.getAlias();
			} else {
				// Custom Aggregates
				String path = agExp.getPath().stream().map(p -> p.getSegmentValue()).collect(Collectors.joining("."));
				func = aggregator.customAggregate(agExp.getPath());
				alias = path.startsWith("$") ? agExp.getAlias() : path;
			}
			items.add(func.as(alias));

		}
	}

	@Override
	public List<CqnSelectListValue> aggregateExpressions() {
		return items;
	}
}
