/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import static java.util.stream.Collectors.toMap;

import java.util.List;
import java.util.Map;

import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.transformation.CqnCustomTransformation;

public class CustomTransformation implements CqnCustomTransformation {

	private final String name;
	private final Map<String, CqnToken> parameters;

	public CustomTransformation(CustomFunction customFunction, ExpressionParser expressionParser) {
		this.name = customFunction.getFunction().getFullQualifiedName().getFullQualifiedNameAsString();
		this.parameters = new ParamConverter(expressionParser).convert(customFunction.getParameters());
	}

	private static class ParamConverter {
		private final ExpressionParser parser;

		public ParamConverter(ExpressionParser expressionParser) {
			this.parser = expressionParser;
		}

		public Map<String, CqnToken> convert(List<UriParameter> parameters) {
			return parameters.stream().collect(toMap(UriParameter::getName, this::convertParam));
		}

		private CqnToken convertParam(UriParameter p) {
			Expression expr = p.getExpression();
			if (expr != null) {
				return parser.parseToken(expr);
			} else {
				return CQL.val(p.getText());
			}
		}
	}

	@Override
	public String name() {
		return name;
	}

	@Override
	public Map<String, CqnToken> parameters() {
		return parameters;
	}
}
