/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.transformation.CqnFilterTransformation;

public class FilterTransformation implements CqnFilterTransformation {

	private final CqnPredicate filter;

	public FilterTransformation(Filter odataFilter, ExpressionParser expressionParser) {
		FilterOption filterOption = odataFilter.getFilterOption();

		filter = expressionParser.parseFilter(filterOption.getExpression());
	}

	@Override
	public CqnPredicate filter() {
		return filter;
	}

}
