/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;

public class ComplexCollection2Json extends StructCollection2Json {

	ComplexCollection2Json() {
	}

	@Override
	protected void writeJsonArray(Iterable<Map<String, Object>> rows, JsonGenerator json) throws IOException {
		json.writeStartArray();
		if (rows != null) {
			for (Map<String, Object> row : rows) {
				entity2Json.toJson(row, json);
			}
		}
		json.writeEndArray();
	}
}
