/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class NavigationProperty2Json implements Data2Json<Map<String, Object>> {
	String navigationProperty;
	Struct2Json struct2Json;
	StructCollection2Json entityCollection2Json;
	Data2Json<Map<String, Object>> inlineCount;

	NavigationProperty2Json() {
		// use builder
	}

	@SuppressWarnings("unchecked")
	@Override
	public void toJson(Map<String, Object> row, JsonGenerator json) throws IOException {
		if (inlineCount != null) {
			// The inline counter serializer will remove properties [prop]@count
			// from the result and must be executed first.
			inlineCount.toJson(row, json);
		}

		Object expandedValue = row.get(navigationProperty);
		if (entityCollection2Json != null) {
			entityCollection2Json.toJson((Iterable<Map<String, Object>>) expandedValue, json);
		} else {
			json.writeFieldName(navigationProperty);
			struct2Json.toJson((Map<String, Object>) expandedValue, json);
		}
	}

	@Override
	public String getName() {
		return navigationProperty;
	}
}
