/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.Map;

import org.apache.olingo.commons.api.Constants;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Number2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;

public abstract class StructCollection2Json implements Data2Json<Iterable<Map<String, Object>>> {

	// prepared serializers:
	Struct2Json entity2Json;
	String2Json<Void> nextLink;
	Number2Json<Iterable<Map<String, Object>>> count;
	String2Json<Iterable<Map<String, Object>>> countStr;
	String navigationPropertyName;
	boolean writeOnlyReferences;

	StructCollection2Json() {
	}

	@Override
	public void toJson(Iterable<Map<String, Object>> maps, JsonGenerator json) throws IOException {
		if (navigationPropertyName == null) {
			json.writeStartObject();
			writeMetadata(maps, json);
			json.writeFieldName(Constants.VALUE);
			writeJsonArray(maps, json);
			// operations go here

			if (nextLink!= null) {
				nextLink.toJson(null, json);
			}
			// delta link goes here

			json.writeEndObject();
		} else {
			writeMetadata(maps, json);
			json.writeFieldName(navigationPropertyName);
			writeJsonArray(maps, json);
		}
	}

	private void writeMetadata(Iterable<Map<String, Object>> rows, JsonGenerator json) throws IOException {

		// @context
		if (entity2Json.getContext() != null) {
			entity2Json.getContext().toJson(null, json);
		}

		// @etag
		if (entity2Json.getMetadataEtag() != null) {
			entity2Json.getMetadataEtag().toJson(null, json);
		}

		// @count
		if (count != null) {
			count.toJson(rows, json);
		} else if (countStr != null) {
			countStr.toJson(rows, json);
		}
	}

	protected abstract void writeJsonArray(Iterable<Map<String, Object>> rows, JsonGenerator json) throws IOException;
}
