/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class Boolean2Json<T> implements Data2Json<T> {

	private final String name;
	private final Function<T, Boolean> valueFunc;

	private Boolean2Json(String name, Function<T, Boolean> valueFunc) {
		this.name = name;
		this.valueFunc = valueFunc;
	}

	public static <T> Boolean2Json<T> val(String name, Function<T, Boolean> valueFunc) {
		return new Boolean2Json<T>(name, valueFunc);
	}

	public static Boolean2Json<?> val(String name, Boolean value) {
		return new Boolean2Json<>(name, fixed -> value);
	}

	@Override
	public void toJson(T data, JsonGenerator json) throws IOException {
		Boolean value = valueFunc.apply(data);
		json.writeFieldName(name);
		if (value != null) {
			json.writeBoolean(value);
		} else {
			json.writeNull();
		}
	}

	@Override
	public Object getValue(T data) {
		return valueFunc.apply(data);
	}

	@Override
	public String getName() {
		return name;
	}
}
