/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class BooleanArray2Json<T> implements Data2Json<T> {
	private final String name;
	private final Function<T, List<Boolean>> valueFunc;

	private BooleanArray2Json(String name, Function<T, List<Boolean>> valueFunc) {
		this.name = name;
		this.valueFunc = valueFunc;
	}

	public static <T> BooleanArray2Json<T> val(String name, Function<T, List<Boolean>> valueFunc) {
		return new BooleanArray2Json<T>(name, valueFunc);
	}

	@Override
	public void toJson(T data, JsonGenerator json) throws IOException {
		List<Boolean> values = valueFunc.apply(data);
		json.writeFieldName(name);
		json.writeStartArray();
		if (values != null) {
			for (Boolean v : values) {
				if (v != null) {
					json.writeBoolean(v);
				} else {
					json.writeNull();
				}
			}
		}
		json.writeEndArray();
	}

	@Override
	public String getName() {
		return name;
	}
}
