/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class Object2Json<T> implements Data2Json<T> {

	private final String name;
	private final Function<T, Object> valueFunc;

	private Object2Json(String name, Function<T, Object> valueFunc) {
		this.name = name;
		this.valueFunc = valueFunc;
	}

	public static <T> Object2Json<T> val(String name, Function<T, Object> valueFunc) {
		return new Object2Json<T>(name, valueFunc);
	}

	public static Object2Json<?> val(String name, Object value) {
		return new Object2Json<>(name, fixed -> value);
	}

	@Override
	public void toJson(T data, JsonGenerator json) throws IOException {
		Object value = valueFunc.apply(data);
		json.writeFieldName(name);
		if (value != null) {
			json.writeObject(value);
		} else {
			json.writeNull();
		}
	}

	@Override
	public Object getValue(T data) {
		return valueFunc.apply(data);
	}

	@Override
	public String getName() {
		return name;
	}

}
