/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class ObjectArray2Json<T> implements Data2Json<T> {

	private final String name;
	private final Function<T, List<Object>> valueFunc;

	private ObjectArray2Json(String name, Function<T, List<Object>> valueFunc) {
		this.name = name;
		this.valueFunc = valueFunc;
	}

	public static <T> ObjectArray2Json<T> val(String name, Function<T, List<Object>> valueFunc) {
		return new ObjectArray2Json<T>(name, valueFunc);
	}

	@Override
	public void toJson(T data, JsonGenerator json) throws IOException {
		List<Object> values = valueFunc.apply(data);
		json.writeFieldName(name);
		json.writeStartArray();
		if (values != null) {
			for (Object v : values) {
				if (v != null) {
					json.writeObject(v);
				} else {
					json.writeNull();
				}
			}
		}
		json.writeEndArray();
	}

	@Override
	public String getName() {
		return name;
	}
}
