/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.metadata;

import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;

public class SimpleETagSupport implements ServiceMetadataETagSupport {

	private final String etag;

	public SimpleETagSupport(String etag) {
		this.etag = "W/\"" + etag + "\"";
	}

	@Override
	public String getMetadataETag() {
		return etag;
	}

	@Override
	public String getServiceDocumentETag() {
		return etag;
	}

}
