/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.metadata.provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.model.DynamicModelUtils;

public class EdmxProviderConfiguration implements CdsRuntimeConfiguration {

	private static Logger logger = LoggerFactory.getLogger(EdmxProviderConfiguration.class);

	@Override
	public void providers(CdsRuntimeConfigurer configurer) {
		DefaultEdmxProvider defaultProvider = new DefaultEdmxProvider(configurer.getCdsRuntime());
		configurer.provider(defaultProvider);

		DynamicModelUtils utils = new DynamicModelUtils(configurer.getCdsRuntime());
		if (utils.isDynamicModelEnabled()) {
			configurer.provider(new DynamicEdmxProvider(configurer.getCdsRuntime(), utils, defaultProvider));
			logger.info("Initialized Dynamic EDMX V4 Provider");
		} else {
			logger.info("Initialized Default EDMX V4 Provider");
		}

		Boolean lazyI18n = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getOdataV4().getLazyI18n().isEnabled();
		if (!Boolean.FALSE.equals(lazyI18n)) {
			DefaultEdmxI18nProvider defaultI18nProvider = DefaultEdmxI18nProvider.create();
			configurer.provider(defaultI18nProvider);
			if (Boolean.TRUE.equals(lazyI18n) && utils.isDynamicModelEnabled()) {
				configurer.provider(new DynamicEdmxI18nProvider(configurer.getCdsRuntime(), utils, defaultI18nProvider));
				logger.info("Initialized Dynamic EDMX I18n Provider");
			} else {
				logger.info("Initialized Default EDMX I18n Provider");
			}
		}
	}

	@Override
	public int order() {
		return Integer.MIN_VALUE;
	}

}
