/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query;

import static org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind.COUNT;
import static org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind.SKIPTOKEN;

import java.net.URI;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.olingo.server.api.ODataRequest;

import com.sap.cds.services.utils.StringUtils;

public class NextLinkInfo {

	private static final String AMP = "&";
	private static final String SKIPTOKEN_ENC = "%24skiptoken";
	private static final String COUNT_ENC = "%24count";
	private String skipToken;

	public NextLinkInfo(String skipToken) {
		this.skipToken = skipToken;
	}

	public URI getNextLink(ODataRequest odataRequest) {
		String odataPath = odataRequest.getRawODataPath().substring(1); // skip initial '/'
		String query = StringUtils.isEmpty(odataRequest.getRawQueryPath()) ? "" : odataRequest.getRawQueryPath();

		String filteredQuery = "";
		if (!StringUtils.isEmpty(query)) {
			filteredQuery = Stream.of(query.split(AMP))
					.filter(q -> !q.startsWith(SKIPTOKEN.toString()) && !q.startsWith(SKIPTOKEN_ENC))
					.filter(q -> !q.startsWith(COUNT.toString()) && !q.startsWith(COUNT_ENC))
					.collect(Collectors.joining(AMP));
		}

		String skipTokenQuery = SKIPTOKEN + "=" + skipToken;
		String fullQuery = StringUtils.isEmpty(filteredQuery) ? skipTokenQuery
				: (filteredQuery + AMP + skipTokenQuery);

		return URI.create(odataPath + "?" + fullQuery);
	}
}
