/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import java.util.ArrayList;
import java.util.List;

import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.SelectBuilder;

public class ApplyHandler {

	private final List<List<CqnTransformation>> unfoldedItems;
	private static final ApplyHandler NOOP = new ApplyHandler(List.of(), null);

	public ApplyHandler(List<ApplyItem> items, ExpressionParser expressionParser) {
		unfoldedItems = new ApplyConverter(expressionParser).unfoldAndConvert(items);
	}

	public List<CqnTransformation> getTransformations(int i) {
		return unfoldedItems.get(i);
	}

	public List<Select<?>> transform(Select<?> select) {
		List<Select<?>> selects = new ArrayList<>(unfoldedItems.size());
		for (List<CqnTransformation> transformations : unfoldedItems) {
			SelectBuilder<?> copy = SelectBuilder.copy(select);
			copy.transformations(transformations);
			selects.add(copy);
		}
		return selects;
	}

	public boolean hasConcat() {
		return unfoldedItems.size() > 1;
	}

	public static ApplyHandler create(ApplyOption applyOption, ExpressionParser expressionParser) {
		if (applyOption == null) {
			return NOOP;
		}

		return new ApplyHandler(applyOption.getApplyItems(), expressionParser);
	}

}
