/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.olingo.server.api.uri.queryoption.apply.Compute;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.transformation.CqnComputeTransformation;

public class ComputeTransformation implements CqnComputeTransformation {

	private List<CqnSelectListValue> computed;

	public ComputeTransformation(Compute compute, ExpressionParser expressionParser) {
		this.computed = compute.getExpressions().stream()
				.map(ex -> ((Value<?>)expressionParser.parseValue(ex.getExpression())).as(ex.getAlias()))
				.collect(Collectors.toList());

	}

	@Override
	public List<CqnSelectListValue> computedItems() {
		return computed;
	}
}
